/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import org.torproject.descriptor.BridgePoolAssignment;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.ParseHelper;

public class BridgePoolAssignmentImpl
extends DescriptorImpl
implements BridgePoolAssignment {
    private static final long serialVersionUID = -8370471568586190472L;
    private long publishedMillis;
    private final Map<String, List<String>> entries = new TreeMap<String, List<String>>();

    protected BridgePoolAssignmentImpl(byte[] rawDescriptorBytes, int[] offsetAndlength, File descriptorFile) throws DescriptorParseException {
        super(rawDescriptorBytes, offsetAndlength, descriptorFile, false);
        this.parseDescriptorBytes();
        this.checkExactlyOnceKeys(EnumSet.of(Key.BRIDGE_POOL_ASSIGNMENT));
        this.checkFirstKey(Key.BRIDGE_POOL_ASSIGNMENT);
        this.clearParsedKeys();
    }

    private void parseDescriptorBytes() throws DescriptorParseException {
        Scanner scanner = this.newScanner().useDelimiter("\n");
        while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.startsWith(Key.BRIDGE_POOL_ASSIGNMENT.keyword + " ")) {
                this.parseBridgePoolAssignmentLine(line);
                continue;
            }
            this.parseBridgeLine(line);
        }
    }

    private void parseBridgePoolAssignmentLine(String line) throws DescriptorParseException {
        String[] parts = line.split("[ \t]+");
        if (parts.length != 3) {
            throw new DescriptorParseException("Illegal line '" + line + "' in bridge pool assignment.");
        }
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    private void parseBridgeLine(String line) throws DescriptorParseException {
        String[] parts = line.split("[ \t]+");
        if (parts.length < 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in bridge pool assignment.");
        }
        String fingerprint = ParseHelper.parseTwentyByteHexString(line, parts[0]);
        String poolAndDetails = line.substring(line.indexOf(" ") + 1);
        this.entries.computeIfAbsent(fingerprint, k -> new ArrayList()).add(poolAndDetails);
    }

    @Override
    public Map<String, List<String>> getEntries() {
        TreeMap copy = new TreeMap();
        for (Map.Entry<String, List<String>> e : this.entries.entrySet()) {
            copy.put(e.getKey(), List.copyOf((Collection)e.getValue()));
        }
        return Collections.unmodifiableMap(copy);
    }
}

