/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.easymock.IMockBuilder;
import org.easymock.IMocksControl;
import org.easymock.MockType;
import org.easymock.internal.Injector;
import org.easymock.internal.MockBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyMockSupport {
    protected final List<IMocksControl> controls = new ArrayList<IMocksControl>(5);

    public <T> T mock(Class<T> toMock) {
        return this.createControl().createMock(toMock);
    }

    public <T> T mock(String name, Class<T> toMock) {
        return this.createControl().createMock(name, toMock);
    }

    public <T> T mock(MockType type, Class<T> toMock) {
        return this.createControl(type).createMock(toMock);
    }

    public <T> T mock(String name, MockType type, Class<T> toMock) {
        return this.createControl(type).createMock(name, toMock);
    }

    public <T> T strictMock(Class<T> toMock) {
        return this.createStrictControl().createMock(toMock);
    }

    public <T> T strictMock(String name, Class<T> toMock) {
        return this.createStrictControl().createMock(name, toMock);
    }

    public <T> T niceMock(Class<T> toMock) {
        return this.createNiceControl().createMock(toMock);
    }

    public <T> T niceMock(String name, Class<T> toMock) {
        return this.createNiceControl().createMock(name, toMock);
    }

    public <T> IMockBuilder<T> partialMockBuilder(Class<T> toMock) {
        return new MockBuilder<T>(toMock, this);
    }

    public <T> T createMock(MockType type, Class<T> toMock) {
        return this.mock(type, toMock);
    }

    public <T> T createMock(String name, MockType type, Class<T> toMock) {
        return this.mock(name, type, toMock);
    }

    public <T> T createStrictMock(Class<T> toMock) {
        return this.strictMock(toMock);
    }

    public <T> T createStrictMock(String name, Class<T> toMock) {
        return this.strictMock(name, toMock);
    }

    public <T> T createMock(Class<T> toMock) {
        return this.mock(toMock);
    }

    public <T> T createMock(String name, Class<T> toMock) {
        return this.mock(name, toMock);
    }

    public <T> T createNiceMock(Class<T> toMock) {
        return this.niceMock(toMock);
    }

    public <T> T createNiceMock(String name, Class<T> toMock) {
        return this.niceMock(name, toMock);
    }

    public IMocksControl createStrictControl() {
        IMocksControl ctrl = EasyMock.createStrictControl();
        this.controls.add(ctrl);
        return ctrl;
    }

    public <T> IMockBuilder<T> createMockBuilder(Class<T> toMock) {
        return this.partialMockBuilder(toMock);
    }

    public IMocksControl createControl(MockType type) {
        IMocksControl ctrl = EasyMock.createControl(type);
        this.controls.add(ctrl);
        return ctrl;
    }

    public IMocksControl createControl() {
        return this.createControl(MockType.DEFAULT);
    }

    public IMocksControl createNiceControl() {
        IMocksControl ctrl = EasyMock.createNiceControl();
        this.controls.add(ctrl);
        return ctrl;
    }

    public void replayAll() {
        for (IMocksControl c : this.controls) {
            c.replay();
        }
    }

    public void resetAll() {
        for (IMocksControl c : this.controls) {
            c.reset();
        }
    }

    public void verifyAll() {
        for (IMocksControl c : this.controls) {
            c.verify();
        }
    }

    public void resetAllToNice() {
        for (IMocksControl c : this.controls) {
            c.resetToNice();
        }
    }

    public void resetAllToDefault() {
        for (IMocksControl c : this.controls) {
            c.resetToDefault();
        }
    }

    public void resetAllToStrict() {
        for (IMocksControl c : this.controls) {
            c.resetToStrict();
        }
    }

    public static void injectMocks(Object obj) {
        Injector.injectMocks(obj);
    }
}

