/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;

class DeleteCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "DELETE";
    public static final String ARGS = "<mailbox>";

    DeleteCommand() {
    }

    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException, AuthorizationException {
        String mailboxName = this.parser.mailbox(request);
        this.parser.endLine(request);
        MailFolder folder = this.getMailbox(mailboxName, session, true);
        if (session.getSelected() != null && folder.getFullName().equals(session.getSelected().getFullName())) {
            session.deselect();
        }
        session.getHost().deleteMailbox(session.getUser(), mailboxName);
        session.unsolicitedResponses(response);
        response.commandComplete(this);
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }
}

