/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.matchers;

import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpFieldsMatchers;
import org.eclipse.jetty.http.HttpHeader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpFieldsMatchersTest {
    @Test
    public void testContainsHeader() {
        HttpFields fields = new HttpFields();
        fields.put("a", "foo");
        fields.put("b", "bar");
        fields.put("c", "fizz");
        MatcherAssert.assertThat((Object)fields, HttpFieldsMatchers.containsHeader("a"));
    }

    @Test
    public void testNotContainsHeader() {
        HttpFields fields = new HttpFields();
        fields.put("a", "foo");
        fields.put("b", "bar");
        fields.put("c", "fizz");
        AssertionError x = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> MatcherAssert.assertThat((Object)fields, (Matcher)Matchers.not(HttpFieldsMatchers.containsHeader("a")))));
        MatcherAssert.assertThat((Object)((Throwable)((Object)x)).getMessage(), (Matcher)Matchers.containsString((String)"not expecting http field name \"a\""));
    }

    @Test
    public void testContainsHeaderMisMatch() {
        HttpFields fields = new HttpFields();
        fields.put("a", "foo");
        fields.put("b", "bar");
        fields.put("c", "fizz");
        AssertionError x = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> MatcherAssert.assertThat((Object)fields, HttpFieldsMatchers.containsHeader("z"))));
        MatcherAssert.assertThat((Object)((Throwable)((Object)x)).getMessage(), (Matcher)Matchers.containsString((String)"expecting http field name \"z\""));
    }

    @Test
    public void testContainsHeaderValueMisMatchNoSuchHeader() {
        HttpFields fields = new HttpFields();
        fields.put("a", "foo");
        fields.put("b", "bar");
        fields.put("c", "fizz");
        AssertionError x = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> MatcherAssert.assertThat((Object)fields, HttpFieldsMatchers.containsHeaderValue("z", "floom"))));
        MatcherAssert.assertThat((Object)((Throwable)((Object)x)).getMessage(), (Matcher)Matchers.containsString((String)"expecting http header \"z\" with value \"floom\""));
    }

    @Test
    public void testContainsHeaderValueMisMatchNoSuchValue() {
        HttpFields fields = new HttpFields();
        fields.put("a", "foo");
        fields.put("b", "bar");
        fields.put("c", "fizz");
        AssertionError x = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> MatcherAssert.assertThat((Object)fields, HttpFieldsMatchers.containsHeaderValue("a", "floom"))));
        MatcherAssert.assertThat((Object)((Throwable)((Object)x)).getMessage(), (Matcher)Matchers.containsString((String)"expecting http header \"a\" with value \"floom\""));
    }

    @Test
    public void testContainsHeaderValue() {
        HttpFields fields = new HttpFields();
        fields.put("a", "foo");
        fields.put("b", "bar");
        fields.put("c", "fizz");
        fields.put(HttpHeader.CONTENT_TYPE, "text/plain;charset=utf-8");
        MatcherAssert.assertThat((Object)fields, HttpFieldsMatchers.containsHeaderValue("b", "bar"));
        MatcherAssert.assertThat((Object)fields, HttpFieldsMatchers.containsHeaderValue("content-type", "text/plain"));
        MatcherAssert.assertThat((Object)fields, HttpFieldsMatchers.containsHeaderValue("content-type", "charset=UTF-8"));
    }
}

