/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* Generated with cbindgen:0.26.0 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen.
 *
 * This file is generated based on the configuration in
 * `gfx/wgpu_bindings/moz.build`, which directs the build system module
 * `build/RunCbindgen.py` to run the following command at the top of
 * the object file directory:
 *
 *     $CBINDGEN $TOPSRCDIR --lockfile $TOPSRCDIR/Cargo.lock --crate wgpu_bindings --metadata config/cbindgen-metadata.json --cpp-compat > gfx/wgpu_bindings/wgpu_ffi_generated.h
 *
 * where:
 * - $TOPSRCDIR is the top of the Firefox source tree, and
 * - $CBINDGEN is the path to the cbindgen executable provided by mozbuild (the exact version often matters)
 */

#include "nsString.h"

struct WGPUByteBuf;
typedef uint64_t WGPUNonZeroU64;
typedef uint64_t WGPUOption_BufferSize;
typedef uint32_t WGPUOption_NonZeroU32;
typedef uint8_t WGPUOption_NonZeroU8;
typedef uint64_t WGPUOption_AdapterId;
typedef uint64_t WGPUOption_BufferId;
typedef uint64_t WGPUOption_PipelineLayoutId;
typedef uint64_t WGPUOption_BindGroupLayoutId;
typedef uint64_t WGPUOption_SamplerId;
typedef uint64_t WGPUOption_SurfaceId;
typedef uint64_t WGPUOption_TextureViewId;
typedef uint64_t WGPUOption_QuerySetId;

typedef uint64_t WGPUAdapterId;
typedef uint64_t WGPUBindGroupId;
typedef uint64_t WGPUBindGroupLayoutId;
typedef uint64_t WGPUBufferId;
typedef uint64_t WGPUCommandBufferId;
typedef uint64_t WGPUCommandEncoderId;
typedef uint64_t WGPUComputePipelineId;
typedef uint64_t WGPUDeviceId;
typedef uint64_t WGPUPipelineLayoutId;
typedef uint64_t WGPUQuerySetId;
typedef uint64_t WGPUQueueId;
typedef uint64_t WGPURenderBundleId;
typedef uint64_t WGPURenderPipelineId;
typedef uint64_t WGPUSamplerId;
typedef uint64_t WGPUShaderModuleId;
typedef uint64_t WGPUStagingBufferId;
typedef uint64_t WGPUSurfaceId;
typedef uint64_t WGPUTextureId;
typedef uint64_t WGPUTextureViewId;


#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>



#define WGPUEPOCH_MASK ((1 << WGPUEPOCH_BITS) - 1)

#define WGPUMAX_CONCURRENT_SHADER_STAGES 2

#define WGPUMAX_ANISOTROPY 16

#define WGPUMAX_BIND_GROUPS 8

#define WGPUMAX_VERTEX_BUFFERS 16

#define WGPUMAX_COLOR_ATTACHMENTS 8

#define WGPUMAX_MIP_LEVELS 16

/**
 * Maximum binding size for the shaders that only support `i32` indexing.
 * Interestingly, the index itself can't reach that high, because the minimum
 * element size is 4 bytes, but the compiler toolchain still computes the
 * offset at some intermediate point, internally, as i32.
 */
#define WGPUMAX_I32_BINDING_SIZE (1 << 31)

#define WGPUVENDOR 4098

#define WGPUDEVICE_KABY_LAKE_MASK 22784

#define WGPUDEVICE_SKY_LAKE_MASK 6400

/**
 * Buffer-Texture copies must have [`bytes_per_row`] aligned to this number.
 *
 * This doesn't apply to [`Queue::write_texture`][Qwt].
 *
 * [`bytes_per_row`]: ImageDataLayout::bytes_per_row
 * [Qwt]: ../wgpu/struct.Queue.html#method.write_texture
 */
#define WGPUCOPY_BYTES_PER_ROW_ALIGNMENT 256

/**
 * Alignment all push constants need
 */
#define WGPUPUSH_CONSTANT_ALIGNMENT 4

/**
 * Maximum queries in a query set
 */
#define WGPUQUERY_SET_MAX_QUERIES 8192

/**
 * How edges should be handled in texture addressing.
 *
 * Corresponds to [WebGPU `GPUAddressMode`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpuaddressmode).
 */
enum WGPUAddressMode {
  /**
   * Clamp the value to the edge of the texture
   *
   * -0.25 -> 0.0
   * 1.25  -> 1.0
   */
  WGPUAddressMode_ClampToEdge = 0,
  /**
   * Repeat the texture in a tiling fashion
   *
   * -0.25 -> 0.75
   * 1.25 -> 0.25
   */
  WGPUAddressMode_Repeat = 1,
  /**
   * Repeat the texture, mirroring it every repeat
   *
   * -0.25 -> 0.25
   * 1.25 -> 0.75
   */
  WGPUAddressMode_MirrorRepeat = 2,
  /**
   * Clamp the value to the border of the texture
   * Requires feature [`Features::ADDRESS_MODE_CLAMP_TO_BORDER`]
   *
   * -0.25 -> border
   * 1.25 -> border
   */
  WGPUAddressMode_ClampToBorder = 3,
  /**
   * Must be last for serialization purposes
   */
  WGPUAddressMode_Sentinel,
};

/**
 * ASTC block dimensions
 */
enum WGPUAstcBlock {
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px).
   */
  WGPUAstcBlock_B4x4,
  /**
   * 5x4 block compressed texture. 16 bytes per block (6.4 bit/px).
   */
  WGPUAstcBlock_B5x4,
  /**
   * 5x5 block compressed texture. 16 bytes per block (5.12 bit/px).
   */
  WGPUAstcBlock_B5x5,
  /**
   * 6x5 block compressed texture. 16 bytes per block (4.27 bit/px).
   */
  WGPUAstcBlock_B6x5,
  /**
   * 6x6 block compressed texture. 16 bytes per block (3.56 bit/px).
   */
  WGPUAstcBlock_B6x6,
  /**
   * 8x5 block compressed texture. 16 bytes per block (3.2 bit/px).
   */
  WGPUAstcBlock_B8x5,
  /**
   * 8x6 block compressed texture. 16 bytes per block (2.67 bit/px).
   */
  WGPUAstcBlock_B8x6,
  /**
   * 8x8 block compressed texture. 16 bytes per block (2 bit/px).
   */
  WGPUAstcBlock_B8x8,
  /**
   * 10x5 block compressed texture. 16 bytes per block (2.56 bit/px).
   */
  WGPUAstcBlock_B10x5,
  /**
   * 10x6 block compressed texture. 16 bytes per block (2.13 bit/px).
   */
  WGPUAstcBlock_B10x6,
  /**
   * 10x8 block compressed texture. 16 bytes per block (1.6 bit/px).
   */
  WGPUAstcBlock_B10x8,
  /**
   * 10x10 block compressed texture. 16 bytes per block (1.28 bit/px).
   */
  WGPUAstcBlock_B10x10,
  /**
   * 12x10 block compressed texture. 16 bytes per block (1.07 bit/px).
   */
  WGPUAstcBlock_B12x10,
  /**
   * 12x12 block compressed texture. 16 bytes per block (0.89 bit/px).
   */
  WGPUAstcBlock_B12x12,
  /**
   * Must be last for serialization purposes
   */
  WGPUAstcBlock_Sentinel,
};

/**
 * ASTC RGBA channel
 */
enum WGPUAstcChannel {
  /**
   * 8 bit integer RGBA, [0, 255] converted to/from linear-color float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ASTC`] must be enabled to use this channel.
   */
  WGPUAstcChannel_Unorm,
  /**
   * 8 bit integer RGBA, Srgb-color [0, 255] converted to/from linear-color float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ASTC`] must be enabled to use this channel.
   */
  WGPUAstcChannel_UnormSrgb,
  /**
   * floating-point RGBA, linear-color float can be outside of the [0, 1] range.
   *
   * [`Features::TEXTURE_COMPRESSION_ASTC_HDR`] must be enabled to use this channel.
   */
  WGPUAstcChannel_Hdr,
  /**
   * Must be last for serialization purposes
   */
  WGPUAstcChannel_Sentinel,
};

/**
 * Backends supported by wgpu.
 */
enum WGPUBackend
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  /**
   * Dummy backend, used for testing.
   */
  WGPUBackend_Empty = 0,
  /**
   * Vulkan API (Windows, Linux, Android, MacOS via `vulkan-portability`/MoltenVK)
   */
  WGPUBackend_Vulkan = 1,
  /**
   * Metal API (Apple platforms)
   */
  WGPUBackend_Metal = 2,
  /**
   * Direct3D-12 (Windows)
   */
  WGPUBackend_Dx12 = 3,
  /**
   * OpenGL 3.3+ (Windows), OpenGL ES 3.0+ (Linux, Android, MacOS via Angle), and WebGL2
   */
  WGPUBackend_Gl = 4,
  /**
   * WebGPU in the browser
   */
  WGPUBackend_BrowserWebGpu = 5,
  /**
   * Must be last for serialization purposes
   */
  WGPUBackend_Sentinel,
};
#ifndef __cplusplus
typedef uint8_t WGPUBackend;
#endif // __cplusplus

/**
 * Alpha blend factor.
 *
 * Alpha blending is very complicated: see the OpenGL or Vulkan spec for more information.
 *
 * Corresponds to [WebGPU `GPUBlendFactor`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpublendfactor).
 * Values using S1 requires [`Features::DUAL_SOURCE_BLENDING`] and can only be
 * used with the first render target.
 */
enum WGPUBlendFactor {
  /**
   * 0.0
   */
  WGPUBlendFactor_Zero = 0,
  /**
   * 1.0
   */
  WGPUBlendFactor_One = 1,
  /**
   * S.component
   */
  WGPUBlendFactor_Src = 2,
  /**
   * 1.0 - S.component
   */
  WGPUBlendFactor_OneMinusSrc = 3,
  /**
   * S.alpha
   */
  WGPUBlendFactor_SrcAlpha = 4,
  /**
   * 1.0 - S.alpha
   */
  WGPUBlendFactor_OneMinusSrcAlpha = 5,
  /**
   * D.component
   */
  WGPUBlendFactor_Dst = 6,
  /**
   * 1.0 - D.component
   */
  WGPUBlendFactor_OneMinusDst = 7,
  /**
   * D.alpha
   */
  WGPUBlendFactor_DstAlpha = 8,
  /**
   * 1.0 - D.alpha
   */
  WGPUBlendFactor_OneMinusDstAlpha = 9,
  /**
   * min(S.alpha, 1.0 - D.alpha)
   */
  WGPUBlendFactor_SrcAlphaSaturated = 10,
  /**
   * Constant
   */
  WGPUBlendFactor_Constant = 11,
  /**
   * 1.0 - Constant
   */
  WGPUBlendFactor_OneMinusConstant = 12,
  /**
   * S1.component
   */
  WGPUBlendFactor_Src1 = 13,
  /**
   * 1.0 - S1.component
   */
  WGPUBlendFactor_OneMinusSrc1 = 14,
  /**
   * S1.alpha
   */
  WGPUBlendFactor_Src1Alpha = 15,
  /**
   * 1.0 - S1.alpha
   */
  WGPUBlendFactor_OneMinusSrc1Alpha = 16,
  /**
   * Must be last for serialization purposes
   */
  WGPUBlendFactor_Sentinel,
};

/**
 * Alpha blend operation.
 *
 * Alpha blending is very complicated: see the OpenGL or Vulkan spec for more information.
 *
 * Corresponds to [WebGPU `GPUBlendOperation`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpublendoperation).
 */
enum WGPUBlendOperation {
  /**
   * Src + Dst
   */
  WGPUBlendOperation_Add = 0,
  /**
   * Src - Dst
   */
  WGPUBlendOperation_Subtract = 1,
  /**
   * Dst - Src
   */
  WGPUBlendOperation_ReverseSubtract = 2,
  /**
   * min(Src, Dst)
   */
  WGPUBlendOperation_Min = 3,
  /**
   * max(Src, Dst)
   */
  WGPUBlendOperation_Max = 4,
  /**
   * Must be last for serialization purposes
   */
  WGPUBlendOperation_Sentinel,
};

/**
 * The status code provided to the buffer mapping callback.
 *
 * This is very similar to `BufferAccessResult`, except that this is FFI-friendly.
 */
enum WGPUBufferMapAsyncStatus {
  /**
   * The Buffer is successfully mapped, `get_mapped_range` can be called.
   *
   * All other variants of this enum represent failures to map the buffer.
   */
  WGPUBufferMapAsyncStatus_Success,
  /**
   * The buffer is already mapped.
   *
   * While this is treated as an error, it does not prevent mapped range from being accessed.
   */
  WGPUBufferMapAsyncStatus_AlreadyMapped,
  /**
   * Mapping was already requested.
   */
  WGPUBufferMapAsyncStatus_MapAlreadyPending,
  /**
   * An unknown error.
   */
  WGPUBufferMapAsyncStatus_Error,
  /**
   * Mapping was aborted (by unmapping or destroying the buffer before mapping
   * happened).
   */
  WGPUBufferMapAsyncStatus_Aborted,
  /**
   * The context is Lost.
   */
  WGPUBufferMapAsyncStatus_ContextLost,
  /**
   * The buffer is in an invalid state.
   */
  WGPUBufferMapAsyncStatus_Invalid,
  /**
   * The range isn't fully contained in the buffer.
   */
  WGPUBufferMapAsyncStatus_InvalidRange,
  /**
   * The range isn't properly aligned.
   */
  WGPUBufferMapAsyncStatus_InvalidAlignment,
  /**
   * Incompatible usage flags.
   */
  WGPUBufferMapAsyncStatus_InvalidUsageFlags,
  /**
   * Must be last for serialization purposes
   */
  WGPUBufferMapAsyncStatus_Sentinel,
};

/**
 * Comparison function used for depth and stencil operations.
 *
 * Corresponds to [WebGPU `GPUCompareFunction`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpucomparefunction).
 */
enum WGPUCompareFunction {
  /**
   * Function never passes
   */
  WGPUCompareFunction_Never = 1,
  /**
   * Function passes if new value less than existing value
   */
  WGPUCompareFunction_Less = 2,
  /**
   * Function passes if new value is equal to existing value. When using
   * this compare function, make sure to mark your Vertex Shader's `@builtin(position)`
   * output as `@invariant` to prevent artifacting.
   */
  WGPUCompareFunction_Equal = 3,
  /**
   * Function passes if new value is less than or equal to existing value
   */
  WGPUCompareFunction_LessEqual = 4,
  /**
   * Function passes if new value is greater than existing value
   */
  WGPUCompareFunction_Greater = 5,
  /**
   * Function passes if new value is not equal to existing value. When using
   * this compare function, make sure to mark your Vertex Shader's `@builtin(position)`
   * output as `@invariant` to prevent artifacting.
   */
  WGPUCompareFunction_NotEqual = 6,
  /**
   * Function passes if new value is greater than or equal to existing value
   */
  WGPUCompareFunction_GreaterEqual = 7,
  /**
   * Function always passes
   */
  WGPUCompareFunction_Always = 8,
  /**
   * Must be last for serialization purposes
   */
  WGPUCompareFunction_Sentinel,
};

/**
 * Supported physical device types.
 */
enum WGPUDeviceType
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  /**
   * Other or Unknown.
   */
  WGPUDeviceType_Other,
  /**
   * Integrated GPU with shared CPU/GPU memory.
   */
  WGPUDeviceType_IntegratedGpu,
  /**
   * Discrete GPU with separate CPU/GPU memory.
   */
  WGPUDeviceType_DiscreteGpu,
  /**
   * Virtual / Hosted.
   */
  WGPUDeviceType_VirtualGpu,
  /**
   * Cpu / Software Rendering.
   */
  WGPUDeviceType_Cpu,
  /**
   * Must be last for serialization purposes
   */
  WGPUDeviceType_Sentinel,
};
#ifndef __cplusplus
typedef uint8_t WGPUDeviceType;
#endif // __cplusplus

/**
 * Corresponds to an optional discriminant of [`GPUError`] type in the WebGPU API. Strongly
 * correlates to [`GPUErrorFilter`]s.
 *
 * [`GPUError`]: https://gpuweb.github.io/gpuweb/#gpuerror
 * [`GPUErrorFilter`]: https://gpuweb.github.io/gpuweb/#enumdef-gpuerrorfilter
 */
enum WGPUErrorBufferType
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  WGPUErrorBufferType_None = 0,
  WGPUErrorBufferType_DeviceLost = 1,
  WGPUErrorBufferType_Internal = 2,
  WGPUErrorBufferType_OutOfMemory = 3,
  WGPUErrorBufferType_Validation = 4,
  /**
   * Must be last for serialization purposes
   */
  WGPUErrorBufferType_Sentinel,
};
#ifndef __cplusplus
typedef uint8_t WGPUErrorBufferType;
#endif // __cplusplus

/**
 * Face of a vertex.
 *
 * Corresponds to [WebGPU `GPUCullMode`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpucullmode),
 * except that the `"none"` value is represented using `Option<Face>` instead.
 */
enum WGPUFace {
  /**
   * Front face
   */
  WGPUFace_Front = 0,
  /**
   * Back face
   */
  WGPUFace_Back = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPUFace_Sentinel,
};

/**
 * Texel mixing mode when sampling between texels.
 *
 * Corresponds to [WebGPU `GPUFilterMode`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpufiltermode).
 */
enum WGPUFilterMode {
  /**
   * Nearest neighbor sampling.
   *
   * This creates a pixelated effect when used as a mag filter
   */
  WGPUFilterMode_Nearest = 0,
  /**
   * Linear Interpolation
   *
   * This makes textures smooth but blurry when used as a mag filter.
   */
  WGPUFilterMode_Linear = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPUFilterMode_Sentinel,
};

/**
 * Vertex winding order which classifies the "front" face of a triangle.
 *
 * Corresponds to [WebGPU `GPUFrontFace`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpufrontface).
 */
enum WGPUFrontFace {
  /**
   * Triangles with vertices in counter clockwise order are considered the front face.
   *
   * This is the default with right handed coordinate spaces.
   */
  WGPUFrontFace_Ccw = 0,
  /**
   * Triangles with vertices in clockwise order are considered the front face.
   *
   * This is the default with left handed coordinate spaces.
   */
  WGPUFrontFace_Cw = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPUFrontFace_Sentinel,
};

enum WGPUHostMap {
  WGPUHostMap_Read,
  WGPUHostMap_Write,
  /**
   * Must be last for serialization purposes
   */
  WGPUHostMap_Sentinel,
};

/**
 * Format of indices used with pipeline.
 *
 * Corresponds to [WebGPU `GPUIndexFormat`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpuindexformat).
 */
enum WGPUIndexFormat {
  /**
   * Indices are 16 bit unsigned integers.
   */
  WGPUIndexFormat_Uint16 = 0,
  /**
   * Indices are 32 bit unsigned integers.
   */
  WGPUIndexFormat_Uint32 = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPUIndexFormat_Sentinel,
};

/**
 * Operation to perform to the output attachment at the start of a renderpass.
 */
enum WGPULoadOp {
  /**
   * Clear the output attachment with the clear color. Clearing is faster than loading.
   */
  WGPULoadOp_Clear = 0,
  /**
   * Do not clear output attachment.
   */
  WGPULoadOp_Load = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPULoadOp_Sentinel,
};

/**
 * Type of drawing mode for polygons
 */
enum WGPUPolygonMode {
  /**
   * Polygons are filled
   */
  WGPUPolygonMode_Fill = 0,
  /**
   * Polygons are drawn as line segments
   */
  WGPUPolygonMode_Line = 1,
  /**
   * Polygons are drawn as points
   */
  WGPUPolygonMode_Point = 2,
  /**
   * Must be last for serialization purposes
   */
  WGPUPolygonMode_Sentinel,
};

/**
 * Power Preference when choosing a physical adapter.
 *
 * Corresponds to [WebGPU `GPUPowerPreference`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpupowerpreference).
 */
enum WGPUPowerPreference {
  /**
   * Power usage is not considered when choosing an adapter.
   */
  WGPUPowerPreference_None = 0,
  /**
   * Adapter that uses the least possible power. This is often an integrated GPU.
   */
  WGPUPowerPreference_LowPower = 1,
  /**
   * Adapter that has the highest performance. This is often a discrete GPU.
   */
  WGPUPowerPreference_HighPerformance = 2,
  /**
   * Must be last for serialization purposes
   */
  WGPUPowerPreference_Sentinel,
};

/**
 * Primitive type the input mesh is composed of.
 *
 * Corresponds to [WebGPU `GPUPrimitiveTopology`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpuprimitivetopology).
 */
enum WGPUPrimitiveTopology {
  /**
   * Vertex data is a list of points. Each vertex is a new point.
   */
  WGPUPrimitiveTopology_PointList = 0,
  /**
   * Vertex data is a list of lines. Each pair of vertices composes a new line.
   *
   * Vertices `0 1 2 3` create two lines `0 1` and `2 3`
   */
  WGPUPrimitiveTopology_LineList = 1,
  /**
   * Vertex data is a strip of lines. Each set of two adjacent vertices form a line.
   *
   * Vertices `0 1 2 3` create three lines `0 1`, `1 2`, and `2 3`.
   */
  WGPUPrimitiveTopology_LineStrip = 2,
  /**
   * Vertex data is a list of triangles. Each set of 3 vertices composes a new triangle.
   *
   * Vertices `0 1 2 3 4 5` create two triangles `0 1 2` and `3 4 5`
   */
  WGPUPrimitiveTopology_TriangleList = 3,
  /**
   * Vertex data is a triangle strip. Each set of three adjacent vertices form a triangle.
   *
   * Vertices `0 1 2 3 4 5` create four triangles `0 1 2`, `2 1 3`, `2 3 4`, and `4 3 5`
   */
  WGPUPrimitiveTopology_TriangleStrip = 4,
  /**
   * Must be last for serialization purposes
   */
  WGPUPrimitiveTopology_Sentinel,
};

enum WGPURawBindingType {
  WGPURawBindingType_UniformBuffer,
  WGPURawBindingType_StorageBuffer,
  WGPURawBindingType_ReadonlyStorageBuffer,
  WGPURawBindingType_Sampler,
  WGPURawBindingType_SampledTexture,
  WGPURawBindingType_ReadonlyStorageTexture,
  WGPURawBindingType_WriteonlyStorageTexture,
  WGPURawBindingType_ReadWriteStorageTexture,
  /**
   * Must be last for serialization purposes
   */
  WGPURawBindingType_Sentinel,
};

enum WGPURawTextureSampleType {
  WGPURawTextureSampleType_Float,
  WGPURawTextureSampleType_UnfilterableFloat,
  WGPURawTextureSampleType_Uint,
  WGPURawTextureSampleType_Sint,
  WGPURawTextureSampleType_Depth,
  /**
   * Must be last for serialization purposes
   */
  WGPURawTextureSampleType_Sentinel,
};

/**
 * Operation to perform on the stencil value.
 *
 * Corresponds to [WebGPU `GPUStencilOperation`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpustenciloperation).
 */
enum WGPUStencilOperation {
  /**
   * Keep stencil value unchanged.
   */
  WGPUStencilOperation_Keep = 0,
  /**
   * Set stencil value to zero.
   */
  WGPUStencilOperation_Zero = 1,
  /**
   * Replace stencil value with value provided in most recent call to
   * [`RenderPass::set_stencil_reference`][RPssr].
   *
   * [RPssr]: ../wgpu/struct.RenderPass.html#method.set_stencil_reference
   */
  WGPUStencilOperation_Replace = 2,
  /**
   * Bitwise inverts stencil value.
   */
  WGPUStencilOperation_Invert = 3,
  /**
   * Increments stencil value by one, clamping on overflow.
   */
  WGPUStencilOperation_IncrementClamp = 4,
  /**
   * Decrements stencil value by one, clamping on underflow.
   */
  WGPUStencilOperation_DecrementClamp = 5,
  /**
   * Increments stencil value by one, wrapping on overflow.
   */
  WGPUStencilOperation_IncrementWrap = 6,
  /**
   * Decrements stencil value by one, wrapping on underflow.
   */
  WGPUStencilOperation_DecrementWrap = 7,
  /**
   * Must be last for serialization purposes
   */
  WGPUStencilOperation_Sentinel,
};

/**
 * Operation to perform to the output attachment at the end of a renderpass.
 */
enum WGPUStoreOp {
  /**
   * Discards the content of the render target.
   *
   * If you don't care about the contents of the target, this can be faster.
   */
  WGPUStoreOp_Discard = 0,
  /**
   * Store the result of the renderpass.
   */
  WGPUStoreOp_Store = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPUStoreOp_Sentinel,
};

/**
 * Kind of data the texture holds.
 *
 * Corresponds to [WebGPU `GPUTextureAspect`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gputextureaspect).
 */
enum WGPUTextureAspect {
  /**
   * Depth, Stencil, and Color.
   */
  WGPUTextureAspect_All,
  /**
   * Stencil.
   */
  WGPUTextureAspect_StencilOnly,
  /**
   * Depth.
   */
  WGPUTextureAspect_DepthOnly,
  /**
   * Plane 0.
   */
  WGPUTextureAspect_Plane0,
  /**
   * Plane 1.
   */
  WGPUTextureAspect_Plane1,
  /**
   * Plane 2.
   */
  WGPUTextureAspect_Plane2,
  /**
   * Must be last for serialization purposes
   */
  WGPUTextureAspect_Sentinel,
};

/**
 * Dimensionality of a texture.
 *
 * Corresponds to [WebGPU `GPUTextureDimension`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gputexturedimension).
 */
enum WGPUTextureDimension {
  /**
   * 1D texture
   */
  WGPUTextureDimension_D1,
  /**
   * 2D texture
   */
  WGPUTextureDimension_D2,
  /**
   * 3D texture
   */
  WGPUTextureDimension_D3,
  /**
   * Must be last for serialization purposes
   */
  WGPUTextureDimension_Sentinel,
};

/**
 * Dimensions of a particular texture view.
 *
 * Corresponds to [WebGPU `GPUTextureViewDimension`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gputextureviewdimension).
 */
enum WGPUTextureViewDimension {
  /**
   * A one dimensional texture. `texture_1d` in WGSL and `texture1D` in GLSL.
   */
  WGPUTextureViewDimension_D1,
  /**
   * A two dimensional texture. `texture_2d` in WGSL and `texture2D` in GLSL.
   */
  WGPUTextureViewDimension_D2,
  /**
   * A two dimensional array texture. `texture_2d_array` in WGSL and `texture2DArray` in GLSL.
   */
  WGPUTextureViewDimension_D2Array,
  /**
   * A cubemap texture. `texture_cube` in WGSL and `textureCube` in GLSL.
   */
  WGPUTextureViewDimension_Cube,
  /**
   * A cubemap array texture. `texture_cube_array` in WGSL and `textureCubeArray` in GLSL.
   */
  WGPUTextureViewDimension_CubeArray,
  /**
   * A three dimensional texture. `texture_3d` in WGSL and `texture3D` in GLSL.
   */
  WGPUTextureViewDimension_D3,
  /**
   * Must be last for serialization purposes
   */
  WGPUTextureViewDimension_Sentinel,
};

/**
 * Vertex Format for a [`VertexAttribute`] (input).
 *
 * Corresponds to [WebGPU `GPUVertexFormat`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpuvertexformat).
 */
enum WGPUVertexFormat {
  /**
   * Two unsigned bytes (u8). `vec2<u32>` in shaders.
   */
  WGPUVertexFormat_Uint8x2 = 0,
  /**
   * Four unsigned bytes (u8). `vec4<u32>` in shaders.
   */
  WGPUVertexFormat_Uint8x4 = 1,
  /**
   * Two signed bytes (i8). `vec2<i32>` in shaders.
   */
  WGPUVertexFormat_Sint8x2 = 2,
  /**
   * Four signed bytes (i8). `vec4<i32>` in shaders.
   */
  WGPUVertexFormat_Sint8x4 = 3,
  /**
   * Two unsigned bytes (u8). [0, 255] converted to float [0, 1] `vec2<f32>` in shaders.
   */
  WGPUVertexFormat_Unorm8x2 = 4,
  /**
   * Four unsigned bytes (u8). [0, 255] converted to float [0, 1] `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Unorm8x4 = 5,
  /**
   * Two signed bytes (i8). [-127, 127] converted to float [-1, 1] `vec2<f32>` in shaders.
   */
  WGPUVertexFormat_Snorm8x2 = 6,
  /**
   * Four signed bytes (i8). [-127, 127] converted to float [-1, 1] `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Snorm8x4 = 7,
  /**
   * Two unsigned shorts (u16). `vec2<u32>` in shaders.
   */
  WGPUVertexFormat_Uint16x2 = 8,
  /**
   * Four unsigned shorts (u16). `vec4<u32>` in shaders.
   */
  WGPUVertexFormat_Uint16x4 = 9,
  /**
   * Two signed shorts (i16). `vec2<i32>` in shaders.
   */
  WGPUVertexFormat_Sint16x2 = 10,
  /**
   * Four signed shorts (i16). `vec4<i32>` in shaders.
   */
  WGPUVertexFormat_Sint16x4 = 11,
  /**
   * Two unsigned shorts (u16). [0, 65535] converted to float [0, 1] `vec2<f32>` in shaders.
   */
  WGPUVertexFormat_Unorm16x2 = 12,
  /**
   * Four unsigned shorts (u16). [0, 65535] converted to float [0, 1] `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Unorm16x4 = 13,
  /**
   * Two signed shorts (i16). [-32767, 32767] converted to float [-1, 1] `vec2<f32>` in shaders.
   */
  WGPUVertexFormat_Snorm16x2 = 14,
  /**
   * Four signed shorts (i16). [-32767, 32767] converted to float [-1, 1] `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Snorm16x4 = 15,
  /**
   * Two half-precision floats (no Rust equiv). `vec2<f32>` in shaders.
   */
  WGPUVertexFormat_Float16x2 = 16,
  /**
   * Four half-precision floats (no Rust equiv). `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Float16x4 = 17,
  /**
   * One single-precision float (f32). `f32` in shaders.
   */
  WGPUVertexFormat_Float32 = 18,
  /**
   * Two single-precision floats (f32). `vec2<f32>` in shaders.
   */
  WGPUVertexFormat_Float32x2 = 19,
  /**
   * Three single-precision floats (f32). `vec3<f32>` in shaders.
   */
  WGPUVertexFormat_Float32x3 = 20,
  /**
   * Four single-precision floats (f32). `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Float32x4 = 21,
  /**
   * One unsigned int (u32). `u32` in shaders.
   */
  WGPUVertexFormat_Uint32 = 22,
  /**
   * Two unsigned ints (u32). `vec2<u32>` in shaders.
   */
  WGPUVertexFormat_Uint32x2 = 23,
  /**
   * Three unsigned ints (u32). `vec3<u32>` in shaders.
   */
  WGPUVertexFormat_Uint32x3 = 24,
  /**
   * Four unsigned ints (u32). `vec4<u32>` in shaders.
   */
  WGPUVertexFormat_Uint32x4 = 25,
  /**
   * One signed int (i32). `i32` in shaders.
   */
  WGPUVertexFormat_Sint32 = 26,
  /**
   * Two signed ints (i32). `vec2<i32>` in shaders.
   */
  WGPUVertexFormat_Sint32x2 = 27,
  /**
   * Three signed ints (i32). `vec3<i32>` in shaders.
   */
  WGPUVertexFormat_Sint32x3 = 28,
  /**
   * Four signed ints (i32). `vec4<i32>` in shaders.
   */
  WGPUVertexFormat_Sint32x4 = 29,
  /**
   * One double-precision float (f64). `f32` in shaders. Requires [`Features::VERTEX_ATTRIBUTE_64BIT`].
   */
  WGPUVertexFormat_Float64 = 30,
  /**
   * Two double-precision floats (f64). `vec2<f32>` in shaders. Requires [`Features::VERTEX_ATTRIBUTE_64BIT`].
   */
  WGPUVertexFormat_Float64x2 = 31,
  /**
   * Three double-precision floats (f64). `vec3<f32>` in shaders. Requires [`Features::VERTEX_ATTRIBUTE_64BIT`].
   */
  WGPUVertexFormat_Float64x3 = 32,
  /**
   * Four double-precision floats (f64). `vec4<f32>` in shaders. Requires [`Features::VERTEX_ATTRIBUTE_64BIT`].
   */
  WGPUVertexFormat_Float64x4 = 33,
  /**
   * Three unsigned 10-bit integers and one 2-bit integer, packed into a 32-bit integer (u32). [0, 1024] converted to float [0, 1] `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Unorm10_10_10_2 = 34,
  /**
   * Must be last for serialization purposes
   */
  WGPUVertexFormat_Sentinel,
};

/**
 * Whether a vertex buffer is indexed by vertex or by instance.
 *
 * Consider a call to [`RenderPass::draw`] like this:
 *
 * ```ignore
 * render_pass.draw(vertices, instances)
 * ```
 *
 * where `vertices` is a `Range<u32>` of vertex indices, and
 * `instances` is a `Range<u32>` of instance indices.
 *
 * For this call, `wgpu` invokes the vertex shader entry point once
 * for every possible `(v, i)` pair, where `v` is drawn from
 * `vertices` and `i` is drawn from `instances`. These invocations
 * may happen in any order, and will usually run in parallel.
 *
 * Each vertex buffer has a step mode, established by the
 * [`step_mode`] field of its [`VertexBufferLayout`], given when the
 * pipeline was created. Buffers whose step mode is [`Vertex`] use
 * `v` as the index into their contents, whereas buffers whose step
 * mode is [`Instance`] use `i`. The indicated buffer element then
 * contributes zero or more attribute values for the `(v, i)` vertex
 * shader invocation to use, based on the [`VertexBufferLayout`]'s
 * [`attributes`] list.
 *
 * You can visualize the results from all these vertex shader
 * invocations as a matrix with a row for each `i` from `instances`,
 * and with a column for each `v` from `vertices`. In one sense, `v`
 * and `i` are symmetrical: both are used to index vertex buffers and
 * provide attribute values.  But the key difference between `v` and
 * `i` is that line and triangle primitives are built from the values
 * of each row, along which `i` is constant and `v` varies, not the
 * columns.
 *
 * An indexed draw call works similarly:
 *
 * ```ignore
 * render_pass.draw_indexed(indices, base_vertex, instances)
 * ```
 *
 * The only difference is that `v` values are drawn from the contents
 * of the index buffer&mdash;specifically, the subrange of the index
 * buffer given by `indices`&mdash;instead of simply being sequential
 * integers, as they are in a `draw` call.
 *
 * A non-instanced call, where `instances` is `0..1`, is simply a
 * matrix with only one row.
 *
 * Corresponds to [WebGPU `GPUVertexStepMode`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpuvertexstepmode).
 *
 * [`RenderPass::draw`]: ../wgpu/struct.RenderPass.html#method.draw
 * [`VertexBufferLayout`]: ../wgpu/struct.VertexBufferLayout.html
 * [`step_mode`]: ../wgpu/struct.VertexBufferLayout.html#structfield.step_mode
 * [`attributes`]: ../wgpu/struct.VertexBufferLayout.html#structfield.attributes
 * [`Vertex`]: VertexStepMode::Vertex
 * [`Instance`]: VertexStepMode::Instance
 */
enum WGPUVertexStepMode {
  /**
   * Vertex data is advanced every vertex.
   */
  WGPUVertexStepMode_Vertex = 0,
  /**
   * Vertex data is advanced every instance.
   */
  WGPUVertexStepMode_Instance = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPUVertexStepMode_Sentinel,
};

/**
 * Flags for acceleration structures
 */
struct WGPUAccelerationStructureFlags;

/**
 * Flags for acceleration structure geometries
 */
struct WGPUAccelerationStructureGeometryFlags;

struct WGPUAccelerationStructureUses;

struct WGPUAttachmentOps;

/**
 * Pipeline layout creation flags.
 */
struct WGPUBindGroupLayoutFlags;

/**
 * Similar to `wgt::BufferUsages` but for internal use.
 */
struct WGPUBufferUses;

struct WGPUClient;

/**
 * Binary flags listing features that may or may not be present on downlevel adapters.
 *
 * A downlevel adapter is a GPU adapter that WGPU supports, but with potentially limited
 * features, due to the lack of hardware feature support.
 *
 * Flags that are **not** present for a downlevel adapter or device usually indicates
 * non-compliance with the WebGPU specification, but not always.
 *
 * You can check whether a set of flags is compliant through the
 * [`DownlevelCapabilities::is_webgpu_compliant()`] function.
 */
struct WGPUDownlevelFlags;

/**
 * Texture format capability flags.
 */
struct WGPUFormatAspects;

struct WGPUGlobal;

struct WGPUMemoryFlags;

/**
 * Pipeline layout creation flags.
 */
struct WGPUPipelineLayoutFlags;

/**
 * Nanosecond timestamp used by the presentation engine.
 *
 * The specific clock depends on the window system integration (WSI) API used.
 *
 * <table>
 * <tr>
 *     <td>WSI</td>
 *     <td>Clock</td>
 * </tr>
 * <tr>
 *     <td>IDXGISwapchain</td>
 *     <td><a href="https://docs.microsoft.com/en-us/windows/win32/api/profileapi/nf-profileapi-queryperformancecounter">QueryPerformanceCounter</a></td>
 * </tr>
 * <tr>
 *     <td>IPresentationManager</td>
 *     <td><a href="https://docs.microsoft.com/en-us/windows/win32/api/realtimeapiset/nf-realtimeapiset-queryinterrupttimeprecise">QueryInterruptTimePrecise</a></td>
 * </tr>
 * <tr>
 *     <td>CAMetalLayer</td>
 *     <td><a href="https://developer.apple.com/documentation/kernel/1462446-mach_absolute_time">mach_absolute_time</a></td>
 * </tr>
 * <tr>
 *     <td>VK_GOOGLE_display_timing</td>
 *     <td><a href="https://linux.die.net/man/3/clock_gettime">clock_gettime(CLOCK_MONOTONIC)</a></td>
 * </tr>
 * </table>
 */
struct WGPUPresentationTimestamp;

struct WGPUPrivateCapabilities;

/**
 * Flags that affect internal code paths but do not
 * change the exposed feature set.
 */
struct WGPUPrivateCapabilities;

struct WGPUPrivateCapabilities;

/**
 * Set of internal capabilities, which don't show up in the exposed
 * device geometry, but affect the code paths taken internally.
 */
struct WGPUPrivateCapabilities;

struct WGPURecordedComputePass;

struct WGPURecordedRenderPass;

struct WGPURenderBundleEncoder;

struct WGPUTableTypes;

/**
 * Texture format capability flags.
 */
struct WGPUTextureFormatCapabilities;

/**
 * Similar to `wgt::TextureUsages` but for internal use.
 */
struct WGPUTextureUses;

/**
 * Similar to `MTLCounterSamplingPoint`, but a bit higher abstracted for our purposes.
 */
struct WGPUTimestampQuerySupport;

struct WGPUWorkarounds;

/**
 * Flags that indicate necessary workarounds for specific devices or driver bugs
 */
struct WGPUWorkarounds;

/**
 * Workaround flags.
 */
struct WGPUWorkarounds;

struct WGPUByteBuf {
  const uint8_t *data;
  uintptr_t len;
  uintptr_t capacity;
};

struct WGPUInfrastructure {
  struct WGPUClient *client;
  const uint8_t *error;
};

/**
 * Represents the sets of limits an adapter/device supports.
 *
 * We provide three different defaults.
 * - [`Limits::downlevel_defaults()`]. This is a set of limits that is guaranteed to work on almost
 *   all backends, including "downlevel" backends such as OpenGL and D3D11, other than WebGL. For
 *   most applications we recommend using these limits, assuming they are high enough for your
 *   application, and you do not intent to support WebGL.
 * - [`Limits::downlevel_webgl2_defaults()`] This is a set of limits that is lower even than the
 *   [`downlevel_defaults()`], configured to be low enough to support running in the browser using
 *   WebGL2.
 * - [`Limits::default()`]. This is the set of limits that is guaranteed to work on all modern
 *   backends and is guaranteed to be supported by WebGPU. Applications needing more modern
 *   features can use this as a reasonable set of limits if they are targeting only desktop and
 *   modern mobile devices.
 *
 * We recommend starting with the most restrictive limits you can and manually increasing the
 * limits you need boosted. This will let you stay running on all hardware that supports the limits
 * you need.
 *
 * Limits "better" than the default must be supported by the adapter and requested when requesting
 * a device. If limits "better" than the adapter supports are requested, requesting a device will
 * panic. Once a device is requested, you may only use resources up to the limits requested _even_
 * if the adapter supports "better" limits.
 *
 * Requesting limits that are "better" than you need may cause performance to decrease because the
 * implementation needs to support more than is needed. You should ideally only request exactly
 * what you need.
 *
 * Corresponds to [WebGPU `GPUSupportedLimits`](
 * https://gpuweb.github.io/gpuweb/#gpusupportedlimits).
 *
 * [`downlevel_defaults()`]: Limits::downlevel_defaults
 */
struct WGPULimits {
  /**
   * Maximum allowed value for the `size.width` of a texture created with `TextureDimension::D1`.
   * Defaults to 8192. Higher is "better".
   */
  uint32_t max_texture_dimension_1d;
  /**
   * Maximum allowed value for the `size.width` and `size.height` of a texture created with `TextureDimension::D2`.
   * Defaults to 8192. Higher is "better".
   */
  uint32_t max_texture_dimension_2d;
  /**
   * Maximum allowed value for the `size.width`, `size.height`, and `size.depth_or_array_layers`
   * of a texture created with `TextureDimension::D3`.
   * Defaults to 2048. Higher is "better".
   */
  uint32_t max_texture_dimension_3d;
  /**
   * Maximum allowed value for the `size.depth_or_array_layers` of a texture created with `TextureDimension::D2`.
   * Defaults to 256. Higher is "better".
   */
  uint32_t max_texture_array_layers;
  /**
   * Amount of bind groups that can be attached to a pipeline at the same time. Defaults to 4. Higher is "better".
   */
  uint32_t max_bind_groups;
  /**
   * Maximum binding index allowed in `create_bind_group_layout`. Defaults to 1000. Higher is "better".
   */
  uint32_t max_bindings_per_bind_group;
  /**
   * Amount of uniform buffer bindings that can be dynamic in a single pipeline. Defaults to 8. Higher is "better".
   */
  uint32_t max_dynamic_uniform_buffers_per_pipeline_layout;
  /**
   * Amount of storage buffer bindings that can be dynamic in a single pipeline. Defaults to 4. Higher is "better".
   */
  uint32_t max_dynamic_storage_buffers_per_pipeline_layout;
  /**
   * Amount of sampled textures visible in a single shader stage. Defaults to 16. Higher is "better".
   */
  uint32_t max_sampled_textures_per_shader_stage;
  /**
   * Amount of samplers visible in a single shader stage. Defaults to 16. Higher is "better".
   */
  uint32_t max_samplers_per_shader_stage;
  /**
   * Amount of storage buffers visible in a single shader stage. Defaults to 8. Higher is "better".
   */
  uint32_t max_storage_buffers_per_shader_stage;
  /**
   * Amount of storage textures visible in a single shader stage. Defaults to 4. Higher is "better".
   */
  uint32_t max_storage_textures_per_shader_stage;
  /**
   * Amount of uniform buffers visible in a single shader stage. Defaults to 12. Higher is "better".
   */
  uint32_t max_uniform_buffers_per_shader_stage;
  /**
   * Maximum size in bytes of a binding to a uniform buffer. Defaults to 64 KiB. Higher is "better".
   */
  uint32_t max_uniform_buffer_binding_size;
  /**
   * Maximum size in bytes of a binding to a storage buffer. Defaults to 128 MiB. Higher is "better".
   */
  uint32_t max_storage_buffer_binding_size;
  /**
   * Maximum length of `VertexState::buffers` when creating a `RenderPipeline`.
   * Defaults to 8. Higher is "better".
   */
  uint32_t max_vertex_buffers;
  /**
   * A limit above which buffer allocations are guaranteed to fail.
   * Defaults to 256 MiB. Higher is "better".
   *
   * Buffer allocations below the maximum buffer size may not succeed depending on available memory,
   * fragmentation and other factors.
   */
  uint64_t max_buffer_size;
  /**
   * Maximum length of `VertexBufferLayout::attributes`, summed over all `VertexState::buffers`,
   * when creating a `RenderPipeline`.
   * Defaults to 16. Higher is "better".
   */
  uint32_t max_vertex_attributes;
  /**
   * Maximum value for `VertexBufferLayout::array_stride` when creating a `RenderPipeline`.
   * Defaults to 2048. Higher is "better".
   */
  uint32_t max_vertex_buffer_array_stride;
  /**
   * Required `BufferBindingType::Uniform` alignment for `BufferBinding::offset`
   * when creating a `BindGroup`, or for `set_bind_group` `dynamicOffsets`.
   * Defaults to 256. Lower is "better".
   */
  uint32_t min_uniform_buffer_offset_alignment;
  /**
   * Required `BufferBindingType::Storage` alignment for `BufferBinding::offset`
   * when creating a `BindGroup`, or for `set_bind_group` `dynamicOffsets`.
   * Defaults to 256. Lower is "better".
   */
  uint32_t min_storage_buffer_offset_alignment;
  /**
   * Maximum allowed number of components (scalars) of input or output locations for
   * inter-stage communication (vertex outputs to fragment inputs). Defaults to 60.
   * Higher is "better".
   */
  uint32_t max_inter_stage_shader_components;
  /**
   * The maximum allowed number of color attachments.
   */
  uint32_t max_color_attachments;
  /**
   * The maximum number of bytes necessary to hold one sample (pixel or subpixel) of render
   * pipeline output data, across all color attachments.
   */
  uint32_t max_color_attachment_bytes_per_sample;
  /**
   * Maximum number of bytes used for workgroup memory in a compute entry point. Defaults to
   * 16384. Higher is "better".
   */
  uint32_t max_compute_workgroup_storage_size;
  /**
   * Maximum value of the product of the `workgroup_size` dimensions for a compute entry-point.
   * Defaults to 256. Higher is "better".
   */
  uint32_t max_compute_invocations_per_workgroup;
  /**
   * The maximum value of the workgroup_size X dimension for a compute stage `ShaderModule` entry-point.
   * Defaults to 256. Higher is "better".
   */
  uint32_t max_compute_workgroup_size_x;
  /**
   * The maximum value of the workgroup_size Y dimension for a compute stage `ShaderModule` entry-point.
   * Defaults to 256. Higher is "better".
   */
  uint32_t max_compute_workgroup_size_y;
  /**
   * The maximum value of the workgroup_size Z dimension for a compute stage `ShaderModule` entry-point.
   * Defaults to 64. Higher is "better".
   */
  uint32_t max_compute_workgroup_size_z;
  /**
   * The maximum value for each dimension of a `ComputePass::dispatch(x, y, z)` operation.
   * Defaults to 65535. Higher is "better".
   */
  uint32_t max_compute_workgroups_per_dimension;
  /**
   * Minimal number of invocations in a subgroup. Higher is "better".
   */
  uint32_t min_subgroup_size;
  /**
   * Maximal number of invocations in a subgroup. Lower is "better".
   */
  uint32_t max_subgroup_size;
  /**
   * Amount of storage available for push constants in bytes. Defaults to 0. Higher is "better".
   * Requesting more than 0 during device creation requires [`Features::PUSH_CONSTANTS`] to be enabled.
   *
   * Expect the size to be:
   * - Vulkan: 128-256 bytes
   * - DX12: 256 bytes
   * - Metal: 4096 bytes
   * - OpenGL doesn't natively support push constants, and are emulated with uniforms,
   *   so this number is less useful but likely 256.
   */
  uint32_t max_push_constant_size;
  /**
   * Maximum number of live non-sampler bindings.
   *
   * This limit only affects the d3d12 backend. Using a large number will allow the device
   * to create many bind groups at the cost of a large up-front allocation at device creation.
   */
  uint32_t max_non_sampler_bindings;
};

/**
 * Features that are not guaranteed to be supported.
 *
 * These are either part of the webgpu standard, or are extension features supported by
 * wgpu when targeting native.
 *
 * If you want to use a feature, you need to first verify that the adapter supports
 * the feature. If the adapter does not support the feature, requesting a device with it enabled
 * will panic.
 *
 * Corresponds to [WebGPU `GPUFeatureName`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpufeaturename).
 */
typedef uint64_t WGPUFeatures;
/**
 * By default, polygon depth is clipped to 0-1 range before/during rasterization.
 * Anything outside of that range is rejected, and respective fragments are not touched.
 *
 * With this extension, we can disabling clipping. That allows
 * shadow map occluders to be rendered into a tighter depth range.
 *
 * Supported platforms:
 * - desktops
 * - some mobile chips
 *
 * This is a web and native feature.
 */
#define WGPUFeatures_DEPTH_CLIP_CONTROL (uint64_t)(1 << 0)
/**
 * Allows for explicit creation of textures of format [`TextureFormat::Depth32FloatStencil8`]
 *
 * Supported platforms:
 * - Vulkan (mostly)
 * - DX12
 * - Metal
 * - OpenGL
 *
 * This is a web and native feature.
 */
#define WGPUFeatures_DEPTH32FLOAT_STENCIL8 (uint64_t)(1 << 1)
/**
 * Enables BCn family of compressed textures. All BCn textures use 4x4 pixel blocks
 * with 8 or 16 bytes per block.
 *
 * Compressed textures sacrifice some quality in exchange for significantly reduced
 * bandwidth usage.
 *
 * Support for this feature guarantees availability of [`TextureUsages::COPY_SRC | TextureUsages::COPY_DST | TextureUsages::TEXTURE_BINDING`] for BCn formats.
 * [`Features::TEXTURE_ADAPTER_SPECIFIC_FORMAT_FEATURES`] may enable additional usages.
 *
 * Supported Platforms:
 * - desktops
 *
 * This is a web and native feature.
 */
#define WGPUFeatures_TEXTURE_COMPRESSION_BC (uint64_t)(1 << 2)
/**
 * Enables ETC family of compressed textures. All ETC textures use 4x4 pixel blocks.
 * ETC2 RGB and RGBA1 are 8 bytes per block. RTC2 RGBA8 and EAC are 16 bytes per block.
 *
 * Compressed textures sacrifice some quality in exchange for significantly reduced
 * bandwidth usage.
 *
 * Support for this feature guarantees availability of [`TextureUsages::COPY_SRC | TextureUsages::COPY_DST | TextureUsages::TEXTURE_BINDING`] for ETC2 formats.
 * [`Features::TEXTURE_ADAPTER_SPECIFIC_FORMAT_FEATURES`] may enable additional usages.
 *
 * Supported Platforms:
 * - Vulkan on Intel
 * - Mobile (some)
 *
 * This is a web and native feature.
 */
#define WGPUFeatures_TEXTURE_COMPRESSION_ETC2 (uint64_t)(1 << 3)
/**
 * Enables ASTC family of compressed textures. ASTC textures use pixel blocks varying from 4x4 to 12x12.
 * Blocks are always 16 bytes.
 *
 * Compressed textures sacrifice some quality in exchange for significantly reduced
 * bandwidth usage.
 *
 * Support for this feature guarantees availability of [`TextureUsages::COPY_SRC | TextureUsages::COPY_DST | TextureUsages::TEXTURE_BINDING`] for ASTC formats with Unorm/UnormSrgb channel type.
 * [`Features::TEXTURE_ADAPTER_SPECIFIC_FORMAT_FEATURES`] may enable additional usages.
 *
 * Supported Platforms:
 * - Vulkan on Intel
 * - Mobile (some)
 *
 * This is a web and native feature.
 */
#define WGPUFeatures_TEXTURE_COMPRESSION_ASTC (uint64_t)(1 << 4)
/**
 * Enables use of Timestamp Queries. These queries tell the current gpu timestamp when
 * all work before the query is finished.
 *
 * This feature allows the use of
 * - [`RenderPassDescriptor::timestamp_writes`]
 * - [`ComputePassDescriptor::timestamp_writes`]
 * to write out timestamps.
 *
 * For arbitrary timestamp write commands on encoders refer to [`Features::TIMESTAMP_QUERY_INSIDE_ENCODERS`].
 * For arbitrary timestamp write commands on passes refer to [`Features::TIMESTAMP_QUERY_INSIDE_PASSES`].
 *
 * They must be resolved using [`CommandEncoder::resolve_query_set`] into a buffer,
 * then the result must be multiplied by the timestamp period [`Queue::get_timestamp_period`]
 * to get the timestamp in nanoseconds. Multiple timestamps can then be diffed to get the
 * time for operations between them to finish.
 *
 * Supported Platforms:
 * - Vulkan
 * - DX12
 * - Metal
 *
 * This is a web and native feature.
 */
#define WGPUFeatures_TIMESTAMP_QUERY (uint64_t)(1 << 5)
/**
 * Allows non-zero value for the `first_instance` member in indirect draw calls.
 *
 * If this feature is not enabled, and the `first_instance` member is non-zero, the behavior may be:
 * - The draw call is ignored.
 * - The draw call is executed as if the `first_instance` is zero.
 * - The draw call is executed with the correct `first_instance` value.
 *
 * Supported Platforms:
 * - Vulkan (mostly)
 * - DX12
 * - Metal on Apple3+ or Mac1+
 * - OpenGL (Desktop 4.2+ with ARB_shader_draw_parameters only)
 *
 * Not Supported:
 * - OpenGL ES / WebGL
 *
 * This is a web and native feature.
 */
#define WGPUFeatures_INDIRECT_FIRST_INSTANCE (uint64_t)(1 << 6)
/**
 * Allows shaders to acquire the FP16 ability
 *
 * Note: this is not supported in `naga` yet, only through `spirv-passthrough` right now.
 *
 * Supported Platforms:
 * - Vulkan
 * - Metal
 *
 * This is a web and native feature.
 */
#define WGPUFeatures_SHADER_F16 (uint64_t)(1 << 7)
/**
 * Allows for usage of textures of format [`TextureFormat::Rg11b10Float`] as a render target
 *
 * Supported platforms:
 * - Vulkan
 * - DX12
 * - Metal
 *
 * This is a web and native feature.
 */
#define WGPUFeatures_RG11B10UFLOAT_RENDERABLE (uint64_t)(1 << 8)
/**
 * Allows the [`wgpu::TextureUsages::STORAGE_BINDING`] usage on textures with format [`TextureFormat::Bgra8unorm`]
 *
 * Supported Platforms:
 * - Vulkan
 * - DX12
 * - Metal
 *
 * This is a web and native feature.
 */
#define WGPUFeatures_BGRA8UNORM_STORAGE (uint64_t)(1 << 9)
/**
 * Allows textures with formats "r32float", "rg32float", and "rgba32float" to be filterable.
 *
 * Supported Platforms:
 * - Vulkan (mainly on Desktop GPUs)
 * - DX12
 * - Metal on macOS or Apple9+ GPUs, optional on iOS/iPadOS with Apple7/8 GPUs
 * - GL with one of `GL_ARB_color_buffer_float`/`GL_EXT_color_buffer_float`/`OES_texture_float_linear`
 *
 * This is a web and native feature.
 */
#define WGPUFeatures_FLOAT32_FILTERABLE (uint64_t)(1 << 10)
/**
 * Enables normalized `16-bit` texture formats.
 *
 * Supported platforms:
 * - Vulkan
 * - DX12
 * - Metal
 *
 * This is a native only feature.
 */
#define WGPUFeatures_TEXTURE_FORMAT_16BIT_NORM (uint64_t)(1 << 20)
/**
 * Enables ASTC HDR family of compressed textures.
 *
 * Compressed textures sacrifice some quality in exchange for significantly reduced
 * bandwidth usage.
 *
 * Support for this feature guarantees availability of [`TextureUsages::COPY_SRC | TextureUsages::COPY_DST | TextureUsages::TEXTURE_BINDING`] for ASTC formats with the HDR channel type.
 * [`Features::TEXTURE_ADAPTER_SPECIFIC_FORMAT_FEATURES`] may enable additional usages.
 *
 * Supported Platforms:
 * - Metal
 * - Vulkan
 * - OpenGL
 *
 * This is a native only feature.
 */
#define WGPUFeatures_TEXTURE_COMPRESSION_ASTC_HDR (uint64_t)(1 << 21)
/**
 * Enables device specific texture format features.
 *
 * See `TextureFormatFeatures` for a listing of the features in question.
 *
 * By default only texture format properties as defined by the WebGPU specification are allowed.
 * Enabling this feature flag extends the features of each format to the ones supported by the current device.
 * Note that without this flag, read/write storage access is not allowed at all.
 *
 * This extension does not enable additional formats.
 *
 * This is a native only feature.
 */
#define WGPUFeatures_TEXTURE_ADAPTER_SPECIFIC_FORMAT_FEATURES (uint64_t)(1 << 22)
/**
 * Enables use of Pipeline Statistics Queries. These queries tell the count of various operations
 * performed between the start and stop call. Call [`RenderPass::begin_pipeline_statistics_query`] to start
 * a query, then call [`RenderPass::end_pipeline_statistics_query`] to stop one.
 *
 * They must be resolved using [`CommandEncoder::resolve_query_set`] into a buffer.
 * The rules on how these resolve into buffers are detailed in the documentation for [`PipelineStatisticsTypes`].
 *
 * Supported Platforms:
 * - Vulkan
 * - DX12
 *
 * This is a native only feature with a [proposal](https://github.com/gpuweb/gpuweb/blob/0008bd30da2366af88180b511a5d0d0c1dffbc36/proposals/pipeline-statistics-query.md) for the web.
 */
#define WGPUFeatures_PIPELINE_STATISTICS_QUERY (uint64_t)(1 << 23)
/**
 * Allows for timestamp queries directly on command encoders.
 *
 * Implies [`Features::TIMESTAMP_QUERY`] is supported.
 *
 * Additionally allows for timestamp writes on command encoders
 * using  [`CommandEncoder::write_timestamp`].
 *
 * Supported platforms:
 * - Vulkan
 * - DX12
 * - Metal
 *
 * This is a native only feature.
 */
#define WGPUFeatures_TIMESTAMP_QUERY_INSIDE_ENCODERS (uint64_t)(1 << 24)
/**
 * Allows for timestamp queries directly on command encoders.
 *
 * Implies [`Features::TIMESTAMP_QUERY`] & [`Features::TIMESTAMP_QUERY_INSIDE_ENCODERS`] is supported.
 *
 * Additionally allows for timestamp queries to be used inside render & compute passes using:
 * - [`RenderPass::write_timestamp`]
 * - [`ComputePass::write_timestamp`]
 *
 * Supported platforms:
 * - Vulkan
 * - DX12
 * - Metal (AMD & Intel, not Apple GPUs)
 *
 * This is generally not available on tile-based rasterization GPUs.
 *
 * This is a native only feature with a [proposal](https://github.com/gpuweb/gpuweb/blob/0008bd30da2366af88180b511a5d0d0c1dffbc36/proposals/timestamp-query-inside-passes.md) for the web.
 */
#define WGPUFeatures_TIMESTAMP_QUERY_INSIDE_PASSES (uint64_t)(1 << 25)
/**
 * Webgpu only allows the MAP_READ and MAP_WRITE buffer usage to be matched with
 * COPY_DST and COPY_SRC respectively. This removes this requirement.
 *
 * This is only beneficial on systems that share memory between CPU and GPU. If enabled
 * on a system that doesn't, this can severely hinder performance. Only use if you understand
 * the consequences.
 *
 * Supported platforms:
 * - Vulkan
 * - DX12
 * - Metal
 *
 * This is a native only feature.
 */
#define WGPUFeatures_MAPPABLE_PRIMARY_BUFFERS (uint64_t)(1 << 26)
/**
 * Allows the user to create uniform arrays of textures in shaders:
 *
 * ex.
 * - `var textures: binding_array<texture_2d<f32>, 10>` (WGSL)
 * - `uniform texture2D textures[10]` (GLSL)
 *
 * If [`Features::STORAGE_RESOURCE_BINDING_ARRAY`] is supported as well as this, the user
 * may also create uniform arrays of storage textures.
 *
 * ex.
 * - `var textures: array<texture_storage_2d<f32, write>, 10>` (WGSL)
 * - `uniform image2D textures[10]` (GLSL)
 *
 * This capability allows them to exist and to be indexed by dynamically uniform
 * values.
 *
 * Supported platforms:
 * - DX12
 * - Metal (with MSL 2.0+ on macOS 10.13+)
 * - Vulkan
 *
 * This is a native only feature.
 */
#define WGPUFeatures_TEXTURE_BINDING_ARRAY (uint64_t)(1 << 27)
/**
 * Allows the user to create arrays of buffers in shaders:
 *
 * ex.
 * - `var<uniform> buffer_array: array<MyBuffer, 10>` (WGSL)
 * - `uniform myBuffer { ... } buffer_array[10]` (GLSL)
 *
 * This capability allows them to exist and to be indexed by dynamically uniform
 * values.
 *
 * If [`Features::STORAGE_RESOURCE_BINDING_ARRAY`] is supported as well as this, the user
 * may also create arrays of storage buffers.
 *
 * ex.
 * - `var<storage> buffer_array: array<MyBuffer, 10>` (WGSL)
 * - `buffer myBuffer { ... } buffer_array[10]` (GLSL)
 *
 * Supported platforms:
 * - DX12
 * - Vulkan
 *
 * This is a native only feature.
 */
#define WGPUFeatures_BUFFER_BINDING_ARRAY (uint64_t)(1 << 28)
/**
 * Allows the user to create uniform arrays of storage buffers or textures in shaders,
 * if resp. [`Features::BUFFER_BINDING_ARRAY`] or [`Features::TEXTURE_BINDING_ARRAY`]
 * is supported.
 *
 * This capability allows them to exist and to be indexed by dynamically uniform
 * values.
 *
 * Supported platforms:
 * - Metal (with MSL 2.2+ on macOS 10.13+)
 * - Vulkan
 *
 * This is a native only feature.
 */
#define WGPUFeatures_STORAGE_RESOURCE_BINDING_ARRAY (uint64_t)(1 << 29)
/**
 * Allows shaders to index sampled texture and storage buffer resource arrays with dynamically non-uniform values:
 *
 * ex. `texture_array[vertex_data]`
 *
 * In order to use this capability, the corresponding GLSL extension must be enabled like so:
 *
 * `#extension GL_EXT_nonuniform_qualifier : require`
 *
 * and then used either as `nonuniformEXT` qualifier in variable declaration:
 *
 * ex. `layout(location = 0) nonuniformEXT flat in int vertex_data;`
 *
 * or as `nonuniformEXT` constructor:
 *
 * ex. `texture_array[nonuniformEXT(vertex_data)]`
 *
 * WGSL and HLSL do not need any extension.
 *
 * Supported platforms:
 * - DX12
 * - Metal (with MSL 2.0+ on macOS 10.13+)
 * - Vulkan 1.2+ (or VK_EXT_descriptor_indexing)'s shaderSampledImageArrayNonUniformIndexing & shaderStorageBufferArrayNonUniformIndexing feature)
 *
 * This is a native only feature.
 */
#define WGPUFeatures_SAMPLED_TEXTURE_AND_STORAGE_BUFFER_ARRAY_NON_UNIFORM_INDEXING (uint64_t)(1 << 30)
/**
 * Allows shaders to index uniform buffer and storage texture resource arrays with dynamically non-uniform values:
 *
 * ex. `texture_array[vertex_data]`
 *
 * In order to use this capability, the corresponding GLSL extension must be enabled like so:
 *
 * `#extension GL_EXT_nonuniform_qualifier : require`
 *
 * and then used either as `nonuniformEXT` qualifier in variable declaration:
 *
 * ex. `layout(location = 0) nonuniformEXT flat in int vertex_data;`
 *
 * or as `nonuniformEXT` constructor:
 *
 * ex. `texture_array[nonuniformEXT(vertex_data)]`
 *
 * WGSL and HLSL do not need any extension.
 *
 * Supported platforms:
 * - DX12
 * - Metal (with MSL 2.0+ on macOS 10.13+)
 * - Vulkan 1.2+ (or VK_EXT_descriptor_indexing)'s shaderUniformBufferArrayNonUniformIndexing & shaderStorageTextureArrayNonUniformIndexing feature)
 *
 * This is a native only feature.
 */
#define WGPUFeatures_UNIFORM_BUFFER_AND_STORAGE_TEXTURE_ARRAY_NON_UNIFORM_INDEXING (uint64_t)(1 << 31)
/**
 * Allows the user to create bind groups containing arrays with less bindings than the BindGroupLayout.
 *
 * This is a native only feature.
 */
#define WGPUFeatures_PARTIALLY_BOUND_BINDING_ARRAY (uint64_t)(1 << 32)
/**
 * Allows the user to call [`RenderPass::multi_draw_indirect`] and [`RenderPass::multi_draw_indexed_indirect`].
 *
 * Allows multiple indirect calls to be dispatched from a single buffer.
 *
 * Supported platforms:
 * - DX12
 * - Vulkan
 * - Metal on Apple3+ or Mac1+ (Emulated on top of `draw_indirect` and `draw_indexed_indirect`)
 *
 * This is a native only feature.
 *
 * [`RenderPass::multi_draw_indirect`]: ../wgpu/struct.RenderPass.html#method.multi_draw_indirect
 * [`RenderPass::multi_draw_indexed_indirect`]: ../wgpu/struct.RenderPass.html#method.multi_draw_indexed_indirect
 */
#define WGPUFeatures_MULTI_DRAW_INDIRECT (uint64_t)(1 << 33)
/**
 * Allows the user to call [`RenderPass::multi_draw_indirect_count`] and [`RenderPass::multi_draw_indexed_indirect_count`].
 *
 * This allows the use of a buffer containing the actual number of draw calls.
 *
 * Supported platforms:
 * - DX12
 * - Vulkan 1.2+ (or VK_KHR_draw_indirect_count)
 *
 * This is a native only feature.
 *
 * [`RenderPass::multi_draw_indirect_count`]: ../wgpu/struct.RenderPass.html#method.multi_draw_indirect_count
 * [`RenderPass::multi_draw_indexed_indirect_count`]: ../wgpu/struct.RenderPass.html#method.multi_draw_indexed_indirect_count
 */
#define WGPUFeatures_MULTI_DRAW_INDIRECT_COUNT (uint64_t)(1 << 34)
/**
 * Allows the use of push constants: small, fast bits of memory that can be updated
 * inside a [`RenderPass`].
 *
 * Allows the user to call [`RenderPass::set_push_constants`], provide a non-empty array
 * to [`PipelineLayoutDescriptor`], and provide a non-zero limit to [`Limits::max_push_constant_size`].
 *
 * A block of push constants can be declared in WGSL with `var<push_constant>`:
 *
 * ```rust,ignore
 * struct PushConstants { example: f32, }
 * var<push_constant> c: PushConstants;
 * ```
 *
 * In GLSL, this corresponds to `layout(push_constant) uniform Name {..}`.
 *
 * Supported platforms:
 * - DX12
 * - Vulkan
 * - Metal
 * - OpenGL (emulated with uniforms)
 *
 * This is a native only feature.
 *
 * [`RenderPass`]: ../wgpu/struct.RenderPass.html
 * [`PipelineLayoutDescriptor`]: ../wgpu/struct.PipelineLayoutDescriptor.html
 * [`RenderPass::set_push_constants`]: ../wgpu/struct.RenderPass.html#method.set_push_constants
 */
#define WGPUFeatures_PUSH_CONSTANTS (uint64_t)(1 << 35)
/**
 * Allows the use of [`AddressMode::ClampToBorder`] with a border color
 * of [`SamplerBorderColor::Zero`].
 *
 * Supported platforms:
 * - DX12
 * - Vulkan
 * - Metal
 * - OpenGL
 *
 * This is a native only feature.
 */
#define WGPUFeatures_ADDRESS_MODE_CLAMP_TO_ZERO (uint64_t)(1 << 36)
/**
 * Allows the use of [`AddressMode::ClampToBorder`] with a border color
 * other than [`SamplerBorderColor::Zero`].
 *
 * Supported platforms:
 * - DX12
 * - Vulkan
 * - Metal (macOS 10.12+ only)
 * - OpenGL
 *
 * This is a native only feature.
 */
#define WGPUFeatures_ADDRESS_MODE_CLAMP_TO_BORDER (uint64_t)(1 << 37)
/**
 * Allows the user to set [`PolygonMode::Line`] in [`PrimitiveState::polygon_mode`]
 *
 * This allows drawing polygons/triangles as lines (wireframe) instead of filled
 *
 * Supported platforms:
 * - DX12
 * - Vulkan
 * - Metal
 *
 * This is a native only feature.
 */
#define WGPUFeatures_POLYGON_MODE_LINE (uint64_t)(1 << 38)
/**
 * Allows the user to set [`PolygonMode::Point`] in [`PrimitiveState::polygon_mode`]
 *
 * This allows only drawing the vertices of polygons/triangles instead of filled
 *
 * Supported platforms:
 * - Vulkan
 *
 * This is a native only feature.
 */
#define WGPUFeatures_POLYGON_MODE_POINT (uint64_t)(1 << 39)
/**
 * Allows the user to set a overestimation-conservative-rasterization in [`PrimitiveState::conservative`]
 *
 * Processing of degenerate triangles/lines is hardware specific.
 * Only triangles are supported.
 *
 * Supported platforms:
 * - Vulkan
 *
 * This is a native only feature.
 */
#define WGPUFeatures_CONSERVATIVE_RASTERIZATION (uint64_t)(1 << 40)
/**
 * Enables bindings of writable storage buffers and textures visible to vertex shaders.
 *
 * Note: some (tiled-based) platforms do not support vertex shaders with any side-effects.
 *
 * Supported Platforms:
 * - All
 *
 * This is a native only feature.
 */
#define WGPUFeatures_VERTEX_WRITABLE_STORAGE (uint64_t)(1 << 41)
/**
 * Enables clear to zero for textures.
 *
 * Supported platforms:
 * - All
 *
 * This is a native only feature.
 */
#define WGPUFeatures_CLEAR_TEXTURE (uint64_t)(1 << 42)
/**
 * Enables creating shader modules from SPIR-V binary data (unsafe).
 *
 * SPIR-V data is not parsed or interpreted in any way; you can use
 * [`wgpu::make_spirv_raw!`] to check for alignment and magic number when converting from
 * raw bytes.
 *
 * Supported platforms:
 * - Vulkan, in case shader's requested capabilities and extensions agree with
 * Vulkan implementation.
 *
 * This is a native only feature.
 */
#define WGPUFeatures_SPIRV_SHADER_PASSTHROUGH (uint64_t)(1 << 43)
/**
 * Enables multiview render passes and `builtin(view_index)` in vertex shaders.
 *
 * Supported platforms:
 * - Vulkan
 * - OpenGL (web only)
 *
 * This is a native only feature.
 */
#define WGPUFeatures_MULTIVIEW (uint64_t)(1 << 44)
/**
 * Enables using 64-bit types for vertex attributes.
 *
 * Requires SHADER_FLOAT64.
 *
 * Supported Platforms: N/A
 *
 * This is a native only feature.
 */
#define WGPUFeatures_VERTEX_ATTRIBUTE_64BIT (uint64_t)(1 << 45)
/**
 * Allows vertex shaders to have outputs which are not consumed
 * by the fragment shader.
 *
 * Supported platforms:
 * - Vulkan
 * - Metal
 * - OpenGL
 */
#define WGPUFeatures_SHADER_UNUSED_VERTEX_OUTPUT (uint64_t)(1 << 46)
/**
 * Allows for creation of textures of format [`TextureFormat::NV12`]
 *
 * Supported platforms:
 * - DX12
 * - Vulkan
 *
 * This is a native only feature.
 */
#define WGPUFeatures_TEXTURE_FORMAT_NV12 (uint64_t)(1 << 47)
/**
 * Allows for the creation of ray-tracing acceleration structures.
 *
 * Supported platforms:
 * - Vulkan
 *
 * This is a native-only feature.
 */
#define WGPUFeatures_RAY_TRACING_ACCELERATION_STRUCTURE (uint64_t)(1 << 48)
/**
 * Allows for the creation of ray-tracing queries within shaders.
 *
 * Supported platforms:
 * - Vulkan
 *
 * This is a native-only feature.
 */
#define WGPUFeatures_RAY_QUERY (uint64_t)(1 << 49)
/**
 * Enables 64-bit floating point types in SPIR-V shaders.
 *
 * Note: even when supported by GPU hardware, 64-bit floating point operations are
 * frequently between 16 and 64 _times_ slower than equivalent operations on 32-bit floats.
 *
 * Supported Platforms:
 * - Vulkan
 *
 * This is a native only feature.
 */
#define WGPUFeatures_SHADER_F64 (uint64_t)(1 << 50)
/**
 * Allows shaders to use i16. Not currently supported in `naga`, only available through `spirv-passthrough`.
 *
 * Supported platforms:
 * - Vulkan
 *
 * This is a native only feature.
 */
#define WGPUFeatures_SHADER_I16 (uint64_t)(1 << 51)
/**
 * Enables `builtin(primitive_index)` in fragment shaders.
 *
 * Note: enables geometry processing for pipelines using the builtin.
 * This may come with a significant performance impact on some hardware.
 * Other pipelines are not affected.
 *
 * Supported platforms:
 * - Vulkan
 * - DX12
 * - Metal (some)
 * - OpenGL (some)
 *
 * This is a native only feature.
 */
#define WGPUFeatures_SHADER_PRIMITIVE_INDEX (uint64_t)(1 << 52)
/**
 * Allows shaders to use the `early_depth_test` attribute.
 *
 * Supported platforms:
 * - GLES 3.1+
 *
 * This is a native only feature.
 */
#define WGPUFeatures_SHADER_EARLY_DEPTH_TEST (uint64_t)(1 << 53)
/**
 * Allows two outputs from a shader to be used for blending.
 * Note that dual-source blending doesn't support multiple render targets.
 *
 * For more info see the OpenGL ES extension GL_EXT_blend_func_extended.
 *
 * Supported platforms:
 * - OpenGL ES (with GL_EXT_blend_func_extended)
 * - Metal (with MSL 1.2+)
 * - Vulkan (with dualSrcBlend)
 * - DX12
 */
#define WGPUFeatures_DUAL_SOURCE_BLENDING (uint64_t)(1 << 54)
/**
 * Allows shaders to use i64 and u64.
 *
 * Supported platforms:
 * - Vulkan
 * - DX12 (DXC only)
 * - Metal (with MSL 2.3+)
 *
 * This is a native only feature.
 */
#define WGPUFeatures_SHADER_INT64 (uint64_t)(1 << 55)
/**
 * Allows compute and fragment shaders to use the subgroup operation built-ins
 *
 * Supported Platforms:
 * - Vulkan
 * - DX12
 * - Metal
 *
 * This is a native only feature.
 */
#define WGPUFeatures_SUBGROUP (uint64_t)(1 << 56)
/**
 * Allows vertex shaders to use the subgroup operation built-ins
 *
 * Supported Platforms:
 * - Vulkan
 *
 * This is a native only feature.
 */
#define WGPUFeatures_SUBGROUP_VERTEX (uint64_t)(1 << 57)
/**
 * Allows shaders to use the subgroup barrier
 *
 * Supported Platforms:
 * - Vulkan
 * - Metal
 *
 * This is a native only feature.
 */
#define WGPUFeatures_SUBGROUP_BARRIER (uint64_t)(1 << 58)
/**
 * Allows the use of pipeline cache objects
 *
 * Supported platforms:
 * - Vulkan
 *
 * Unimplemented Platforms:
 * - DX12
 * - Metal
 */
#define WGPUFeatures_PIPELINE_CACHE (uint64_t)(1 << 59)

struct WGPUAdapterInformation {
  WGPUAdapterId id;
  struct WGPULimits limits;
  WGPUFeatures features;
  nsString name;
  uint32_t vendor;
  uint32_t device;
  WGPUDeviceType device_type;
  nsString driver;
  nsString driver_info;
  WGPUBackend backend;
};

/**
 * Describes a [`Device`](../wgpu/struct.Device.html).
 *
 * Corresponds to [WebGPU `GPUDeviceDescriptor`](
 * https://gpuweb.github.io/gpuweb/#gpudevicedescriptor).
 */
struct WGPUDeviceDescriptor {
  /**
   * Debug label for the device.
   */
  const nsACString *label;
  /**
   * Specifies the features that are required by the device request.
   * The request will fail if the adapter cannot provide these features.
   *
   * Exactly the specified set of features, and no more or less,
   * will be allowed in validation of API calls on the resulting device.
   */
  WGPUFeatures required_features;
  /**
   * Specifies the limits that are required by the device request.
   * The request will fail if the adapter cannot provide these limits.
   *
   * Exactly the specified limits, and no better or worse,
   * will be allowed in validation of API calls on the resulting device.
   */
  struct WGPULimits required_limits;
};

/**
 * Extent of a texture related operation.
 *
 * Corresponds to [WebGPU `GPUExtent3D`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpuextent3ddict).
 */
struct WGPUExtent3d {
  /**
   * Width of the extent
   */
  uint32_t width;
  /**
   * Height of the extent
   */
  uint32_t height;
  /**
   * The depth of the extent or the number of array layers
   */
  uint32_t depth_or_array_layers;
};

/**
 * Underlying texture data format.
 *
 * If there is a conversion in the format (such as srgb -> linear), the conversion listed here is for
 * loading from texture in a shader. When writing to the texture, the opposite conversion takes place.
 *
 * Corresponds to [WebGPU `GPUTextureFormat`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gputextureformat).
 */
enum WGPUTextureFormat_Tag {
  /**
   * Red channel only. 8 bit integer per channel. [0, 255] converted to/from float [0, 1] in shader.
   */
  WGPUTextureFormat_R8Unorm,
  /**
   * Red channel only. 8 bit integer per channel. [-127, 127] converted to/from float [-1, 1] in shader.
   */
  WGPUTextureFormat_R8Snorm,
  /**
   * Red channel only. 8 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_R8Uint,
  /**
   * Red channel only. 8 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_R8Sint,
  /**
   * Red channel only. 16 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_R16Uint,
  /**
   * Red channel only. 16 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_R16Sint,
  /**
   * Red channel only. 16 bit integer per channel. [0, 65535] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_FORMAT_16BIT_NORM`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_R16Unorm,
  /**
   * Red channel only. 16 bit integer per channel. [0, 65535] converted to/from float [-1, 1] in shader.
   *
   * [`Features::TEXTURE_FORMAT_16BIT_NORM`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_R16Snorm,
  /**
   * Red channel only. 16 bit float per channel. Float in shader.
   */
  WGPUTextureFormat_R16Float,
  /**
   * Red and green channels. 8 bit integer per channel. [0, 255] converted to/from float [0, 1] in shader.
   */
  WGPUTextureFormat_Rg8Unorm,
  /**
   * Red and green channels. 8 bit integer per channel. [-127, 127] converted to/from float [-1, 1] in shader.
   */
  WGPUTextureFormat_Rg8Snorm,
  /**
   * Red and green channels. 8 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rg8Uint,
  /**
   * Red and green channels. 8 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_Rg8Sint,
  /**
   * Red channel only. 32 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_R32Uint,
  /**
   * Red channel only. 32 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_R32Sint,
  /**
   * Red channel only. 32 bit float per channel. Float in shader.
   */
  WGPUTextureFormat_R32Float,
  /**
   * Red and green channels. 16 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rg16Uint,
  /**
   * Red and green channels. 16 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_Rg16Sint,
  /**
   * Red and green channels. 16 bit integer per channel. [0, 65535] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_FORMAT_16BIT_NORM`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Rg16Unorm,
  /**
   * Red and green channels. 16 bit integer per channel. [0, 65535] converted to/from float [-1, 1] in shader.
   *
   * [`Features::TEXTURE_FORMAT_16BIT_NORM`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Rg16Snorm,
  /**
   * Red and green channels. 16 bit float per channel. Float in shader.
   */
  WGPUTextureFormat_Rg16Float,
  /**
   * Red, green, blue, and alpha channels. 8 bit integer per channel. [0, 255] converted to/from float [0, 1] in shader.
   */
  WGPUTextureFormat_Rgba8Unorm,
  /**
   * Red, green, blue, and alpha channels. 8 bit integer per channel. Srgb-color [0, 255] converted to/from linear-color float [0, 1] in shader.
   */
  WGPUTextureFormat_Rgba8UnormSrgb,
  /**
   * Red, green, blue, and alpha channels. 8 bit integer per channel. [-127, 127] converted to/from float [-1, 1] in shader.
   */
  WGPUTextureFormat_Rgba8Snorm,
  /**
   * Red, green, blue, and alpha channels. 8 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rgba8Uint,
  /**
   * Red, green, blue, and alpha channels. 8 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_Rgba8Sint,
  /**
   * Blue, green, red, and alpha channels. 8 bit integer per channel. [0, 255] converted to/from float [0, 1] in shader.
   */
  WGPUTextureFormat_Bgra8Unorm,
  /**
   * Blue, green, red, and alpha channels. 8 bit integer per channel. Srgb-color [0, 255] converted to/from linear-color float [0, 1] in shader.
   */
  WGPUTextureFormat_Bgra8UnormSrgb,
  /**
   * Packed unsigned float with 9 bits mantisa for each RGB component, then a common 5 bits exponent
   */
  WGPUTextureFormat_Rgb9e5Ufloat,
  /**
   * Red, green, blue, and alpha channels. 10 bit integer for RGB channels, 2 bit integer for alpha channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rgb10a2Uint,
  /**
   * Red, green, blue, and alpha channels. 10 bit integer for RGB channels, 2 bit integer for alpha channel. [0, 1023] ([0, 3] for alpha) converted to/from float [0, 1] in shader.
   */
  WGPUTextureFormat_Rgb10a2Unorm,
  /**
   * Red, green, and blue channels. 11 bit float with no sign bit for RG channels. 10 bit float with no sign bit for blue channel. Float in shader.
   */
  WGPUTextureFormat_Rg11b10Float,
  /**
   * Red and green channels. 32 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rg32Uint,
  /**
   * Red and green channels. 32 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_Rg32Sint,
  /**
   * Red and green channels. 32 bit float per channel. Float in shader.
   */
  WGPUTextureFormat_Rg32Float,
  /**
   * Red, green, blue, and alpha channels. 16 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rgba16Uint,
  /**
   * Red, green, blue, and alpha channels. 16 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_Rgba16Sint,
  /**
   * Red, green, blue, and alpha channels. 16 bit integer per channel. [0, 65535] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_FORMAT_16BIT_NORM`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Rgba16Unorm,
  /**
   * Red, green, blue, and alpha. 16 bit integer per channel. [0, 65535] converted to/from float [-1, 1] in shader.
   *
   * [`Features::TEXTURE_FORMAT_16BIT_NORM`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Rgba16Snorm,
  /**
   * Red, green, blue, and alpha channels. 16 bit float per channel. Float in shader.
   */
  WGPUTextureFormat_Rgba16Float,
  /**
   * Red, green, blue, and alpha channels. 32 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rgba32Uint,
  /**
   * Red, green, blue, and alpha channels. 32 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_Rgba32Sint,
  /**
   * Red, green, blue, and alpha channels. 32 bit float per channel. Float in shader.
   */
  WGPUTextureFormat_Rgba32Float,
  /**
   * Stencil format with 8 bit integer stencil.
   */
  WGPUTextureFormat_Stencil8,
  /**
   * Special depth format with 16 bit integer depth.
   */
  WGPUTextureFormat_Depth16Unorm,
  /**
   * Special depth format with at least 24 bit integer depth.
   */
  WGPUTextureFormat_Depth24Plus,
  /**
   * Special depth/stencil format with at least 24 bit integer depth and 8 bits integer stencil.
   */
  WGPUTextureFormat_Depth24PlusStencil8,
  /**
   * Special depth format with 32 bit floating point depth.
   */
  WGPUTextureFormat_Depth32Float,
  /**
   * Special depth/stencil format with 32 bit floating point depth and 8 bits integer stencil.
   *
   * [`Features::DEPTH32FLOAT_STENCIL8`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Depth32FloatStencil8,
  /**
   * YUV 4:2:0 chroma subsampled format.
   *
   * Contains two planes:
   * - 0: Single 8 bit channel luminance.
   * - 1: Dual 8 bit channel chrominance at half width and half height.
   *
   * Valid view formats for luminance are [`TextureFormat::R8Unorm`].
   *
   * Valid view formats for chrominance are [`TextureFormat::Rg8Unorm`].
   *
   * Width and height must be even.
   *
   * [`Features::TEXTURE_FORMAT_NV12`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_NV12,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). 4 color + alpha pallet. 5 bit R + 6 bit G + 5 bit B + 1 bit alpha.
   * [0, 63] ([0, 1] for alpha) converted to/from float [0, 1] in shader.
   *
   * Also known as DXT1.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc1RgbaUnorm,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). 4 color + alpha pallet. 5 bit R + 6 bit G + 5 bit B + 1 bit alpha.
   * Srgb-color [0, 63] ([0, 1] for alpha) converted to/from linear-color float [0, 1] in shader.
   *
   * Also known as DXT1.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc1RgbaUnormSrgb,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). 4 color pallet. 5 bit R + 6 bit G + 5 bit B + 4 bit alpha.
   * [0, 63] ([0, 15] for alpha) converted to/from float [0, 1] in shader.
   *
   * Also known as DXT3.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc2RgbaUnorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). 4 color pallet. 5 bit R + 6 bit G + 5 bit B + 4 bit alpha.
   * Srgb-color [0, 63] ([0, 255] for alpha) converted to/from linear-color float [0, 1] in shader.
   *
   * Also known as DXT3.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc2RgbaUnormSrgb,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). 4 color pallet + 8 alpha pallet. 5 bit R + 6 bit G + 5 bit B + 8 bit alpha.
   * [0, 63] ([0, 255] for alpha) converted to/from float [0, 1] in shader.
   *
   * Also known as DXT5.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc3RgbaUnorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). 4 color pallet + 8 alpha pallet. 5 bit R + 6 bit G + 5 bit B + 8 bit alpha.
   * Srgb-color [0, 63] ([0, 255] for alpha) converted to/from linear-color float [0, 1] in shader.
   *
   * Also known as DXT5.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc3RgbaUnormSrgb,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). 8 color pallet. 8 bit R.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * Also known as RGTC1.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc4RUnorm,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). 8 color pallet. 8 bit R.
   * [-127, 127] converted to/from float [-1, 1] in shader.
   *
   * Also known as RGTC1.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc4RSnorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). 8 color red pallet + 8 color green pallet. 8 bit RG.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * Also known as RGTC2.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc5RgUnorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). 8 color red pallet + 8 color green pallet. 8 bit RG.
   * [-127, 127] converted to/from float [-1, 1] in shader.
   *
   * Also known as RGTC2.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc5RgSnorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Variable sized pallet. 16 bit unsigned float RGB. Float in shader.
   *
   * Also known as BPTC (float).
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc6hRgbUfloat,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Variable sized pallet. 16 bit signed float RGB. Float in shader.
   *
   * Also known as BPTC (float).
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc6hRgbFloat,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Variable sized pallet. 8 bit integer RGBA.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * Also known as BPTC (unorm).
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc7RgbaUnorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Variable sized pallet. 8 bit integer RGBA.
   * Srgb-color [0, 255] converted to/from linear-color float [0, 1] in shader.
   *
   * Also known as BPTC (unorm).
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Bc7RgbaUnormSrgb,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). Complex pallet. 8 bit integer RGB.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Etc2Rgb8Unorm,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). Complex pallet. 8 bit integer RGB.
   * Srgb-color [0, 255] converted to/from linear-color float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Etc2Rgb8UnormSrgb,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). Complex pallet. 8 bit integer RGB + 1 bit alpha.
   * [0, 255] ([0, 1] for alpha) converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Etc2Rgb8A1Unorm,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). Complex pallet. 8 bit integer RGB + 1 bit alpha.
   * Srgb-color [0, 255] ([0, 1] for alpha) converted to/from linear-color float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Etc2Rgb8A1UnormSrgb,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Complex pallet. 8 bit integer RGB + 8 bit alpha.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Etc2Rgba8Unorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Complex pallet. 8 bit integer RGB + 8 bit alpha.
   * Srgb-color [0, 255] converted to/from linear-color float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Etc2Rgba8UnormSrgb,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). Complex pallet. 11 bit integer R.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_EacR11Unorm,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). Complex pallet. 11 bit integer R.
   * [-127, 127] converted to/from float [-1, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_EacR11Snorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Complex pallet. 11 bit integer R + 11 bit integer G.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_EacRg11Unorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Complex pallet. 11 bit integer R + 11 bit integer G.
   * [-127, 127] converted to/from float [-1, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_EacRg11Snorm,
  /**
   * block compressed texture. 16 bytes per block.
   *
   * Features [`TEXTURE_COMPRESSION_ASTC`] or [`TEXTURE_COMPRESSION_ASTC_HDR`]
   * must be enabled to use this texture format.
   *
   * [`TEXTURE_COMPRESSION_ASTC`]: Features::TEXTURE_COMPRESSION_ASTC
   * [`TEXTURE_COMPRESSION_ASTC_HDR`]: Features::TEXTURE_COMPRESSION_ASTC_HDR
   */
  WGPUTextureFormat_Astc,
  /**
   * Must be last for serialization purposes
   */
  WGPUTextureFormat_Sentinel,
};

struct WGPUTextureFormat_WGPUAstc_Body {
  /**
   * compressed block dimensions
   */
  enum WGPUAstcBlock block;
  /**
   * ASTC RGBA channel
   */
  enum WGPUAstcChannel channel;
};

struct WGPUTextureFormat {
  enum WGPUTextureFormat_Tag tag;
  union {
    struct WGPUTextureFormat_WGPUAstc_Body astc;
  };
};

/**
 * Different ways that you can use a texture.
 *
 * The usages determine what kind of memory the texture is allocated from and what
 * actions the texture can partake in.
 *
 * Corresponds to [WebGPU `GPUTextureUsageFlags`](
 * https://gpuweb.github.io/gpuweb/#typedefdef-gputextureusageflags).
 */
typedef uint32_t WGPUTextureUsages;
/**
 * Allows a texture to be the source in a [`CommandEncoder::copy_texture_to_buffer`] or
 * [`CommandEncoder::copy_texture_to_texture`] operation.
 */
#define WGPUTextureUsages_COPY_SRC (uint32_t)(1 << 0)
/**
 * Allows a texture to be the destination in a  [`CommandEncoder::copy_buffer_to_texture`],
 * [`CommandEncoder::copy_texture_to_texture`], or [`Queue::write_texture`] operation.
 */
#define WGPUTextureUsages_COPY_DST (uint32_t)(1 << 1)
/**
 * Allows a texture to be a [`BindingType::Texture`] in a bind group.
 */
#define WGPUTextureUsages_TEXTURE_BINDING (uint32_t)(1 << 2)
/**
 * Allows a texture to be a [`BindingType::StorageTexture`] in a bind group.
 */
#define WGPUTextureUsages_STORAGE_BINDING (uint32_t)(1 << 3)
/**
 * Allows a texture to be an output attachment of a render pass.
 */
#define WGPUTextureUsages_RENDER_ATTACHMENT (uint32_t)(1 << 4)

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_TextureFormat {
  const struct WGPUTextureFormat *data;
  uintptr_t length;
};

/**
 * Describes a [`Texture`](../wgpu/struct.Texture.html).
 *
 * Corresponds to [WebGPU `GPUTextureDescriptor`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gputexturedescriptor).
 */
struct WGPUTextureDescriptor {
  /**
   * Debug label of the texture. This will show up in graphics debuggers for easy identification.
   */
  const nsACString *label;
  /**
   * Size of the texture. All components must be greater than zero. For a
   * regular 1D/2D texture, the unused sizes will be 1. For 2DArray textures,
   * Z is the number of 2D textures in that array.
   */
  struct WGPUExtent3d size;
  /**
   * Mip count of texture. For a texture with no extra mips, this must be 1.
   */
  uint32_t mip_level_count;
  /**
   * Sample count of texture. If this is not 1, texture must have [`BindingType::Texture::multisampled`] set to true.
   */
  uint32_t sample_count;
  /**
   * Dimensions of the texture.
   */
  enum WGPUTextureDimension dimension;
  /**
   * Format of the texture.
   */
  struct WGPUTextureFormat format;
  /**
   * Allowed usages of the texture. If used in other ways, the operation will panic.
   */
  WGPUTextureUsages usage;
  /**
   * Specifies what view formats will be allowed when calling create_view() on this texture.
   *
   * View formats of the same format as the texture are always allowed.
   *
   * Note: currently, only the srgb-ness is allowed to change. (ex: Rgba8Unorm texture + Rgba8UnormSrgb view)
   */
  struct WGPUFfiSlice_TextureFormat view_formats;
};

struct WGPUSwapChainId {
  uint64_t _0;
};

struct WGPUTextureViewDescriptor {
  const nsACString *label;
  const struct WGPUTextureFormat *format;
  const enum WGPUTextureViewDimension *dimension;
  enum WGPUTextureAspect aspect;
  uint32_t base_mip_level;
  const uint32_t *mip_level_count;
  uint32_t base_array_layer;
  const uint32_t *array_layer_count;
};

struct WGPUSamplerDescriptor {
  const nsACString *label;
  enum WGPUAddressMode address_modes[3];
  enum WGPUFilterMode mag_filter;
  enum WGPUFilterMode min_filter;
  enum WGPUFilterMode mipmap_filter;
  float lod_min_clamp;
  float lod_max_clamp;
  const enum WGPUCompareFunction *compare;
  uint16_t max_anisotropy;
};

/**
 * Describes a [`CommandEncoder`](../wgpu/struct.CommandEncoder.html).
 *
 * Corresponds to [WebGPU `GPUCommandEncoderDescriptor`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpucommandencoderdescriptor).
 */
struct WGPUCommandEncoderDescriptor {
  /**
   * Debug label for the command encoder. This will show up in graphics debuggers for easy identification.
   */
  const nsACString *label;
};

struct WGPURenderBundleEncoderDescriptor {
  const nsACString *label;
  const struct WGPUTextureFormat *color_formats;
  uintptr_t color_formats_length;
  const struct WGPUTextureFormat *depth_stencil_format;
  bool depth_read_only;
  bool stencil_read_only;
  uint32_t sample_count;
};

/**
 * Describes a [`RenderBundle`](../wgpu/struct.RenderBundle.html).
 *
 * Corresponds to [WebGPU `GPURenderBundleDescriptor`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpurenderbundledescriptor).
 */
struct WGPURenderBundleDescriptor {
  /**
   * Debug label of the render bundle encoder. This will show up in graphics debuggers for easy identification.
   */
  const nsACString *label;
};

struct WGPUComputePassTimestampWrites {
  WGPUQuerySetId query_set;
  const uint32_t *beginning_of_pass_write_index;
  const uint32_t *end_of_pass_write_index;
};

struct WGPUComputePassDescriptor {
  const nsACString *label;
  const struct WGPUComputePassTimestampWrites *timestamp_writes;
};

/**
 * RGBA double precision color.
 *
 * This is not to be used as a generic color type, only for specific wgpu interfaces.
 */
struct WGPUColor {
  /**
   * Red component of the color
   */
  double r;
  /**
   * Green component of the color
   */
  double g;
  /**
   * Blue component of the color
   */
  double b;
  /**
   * Alpha component of the color
   */
  double a;
};
#define WGPUColor_TRANSPARENT (WGPUColor){ .r = 0.0, .g = 0.0, .b = 0.0, .a = 0.0 }
#define WGPUColor_BLACK (WGPUColor){ .r = 0.0, .g = 0.0, .b = 0.0, .a = 1.0 }
#define WGPUColor_WHITE (WGPUColor){ .r = 1.0, .g = 1.0, .b = 1.0, .a = 1.0 }
#define WGPUColor_RED (WGPUColor){ .r = 1.0, .g = 0.0, .b = 0.0, .a = 1.0 }
#define WGPUColor_GREEN (WGPUColor){ .r = 0.0, .g = 1.0, .b = 0.0, .a = 1.0 }
#define WGPUColor_BLUE (WGPUColor){ .r = 0.0, .g = 0.0, .b = 1.0, .a = 1.0 }

/**
 * Describes an individual channel within a render pass, such as color, depth, or stencil.
 */
struct WGPUPassChannel_Color {
  /**
   * Operation to perform to the output attachment at the start of a
   * renderpass.
   *
   * This must be clear if it is the first renderpass rendering to a swap
   * chain image.
   */
  enum WGPULoadOp load_op;
  /**
   * Operation to perform to the output attachment at the end of a renderpass.
   */
  enum WGPUStoreOp store_op;
  /**
   * If load_op is [`LoadOp::Clear`], the attachment will be cleared to this
   * color.
   */
  struct WGPUColor clear_value;
  /**
   * If true, the relevant channel is not changed by a renderpass, and the
   * corresponding attachment can be used inside the pass by other read-only
   * usages.
   */
  bool read_only;
};

/**
 * Describes a color attachment to a render pass.
 */
struct WGPURenderPassColorAttachment {
  /**
   * The view to use as an attachment.
   */
  WGPUTextureViewId view;
  /**
   * The view that will receive the resolved output if multisampling is used.
   */
  WGPUOption_TextureViewId resolve_target;
  /**
   * What operations will be performed on this color attachment.
   */
  struct WGPUPassChannel_Color channel;
};

/**
 * Describes an individual channel within a render pass, such as color, depth, or stencil.
 */
struct WGPUPassChannel_f32 {
  /**
   * Operation to perform to the output attachment at the start of a
   * renderpass.
   *
   * This must be clear if it is the first renderpass rendering to a swap
   * chain image.
   */
  enum WGPULoadOp load_op;
  /**
   * Operation to perform to the output attachment at the end of a renderpass.
   */
  enum WGPUStoreOp store_op;
  /**
   * If load_op is [`LoadOp::Clear`], the attachment will be cleared to this
   * color.
   */
  float clear_value;
  /**
   * If true, the relevant channel is not changed by a renderpass, and the
   * corresponding attachment can be used inside the pass by other read-only
   * usages.
   */
  bool read_only;
};

/**
 * Describes an individual channel within a render pass, such as color, depth, or stencil.
 */
struct WGPUPassChannel_u32 {
  /**
   * Operation to perform to the output attachment at the start of a
   * renderpass.
   *
   * This must be clear if it is the first renderpass rendering to a swap
   * chain image.
   */
  enum WGPULoadOp load_op;
  /**
   * Operation to perform to the output attachment at the end of a renderpass.
   */
  enum WGPUStoreOp store_op;
  /**
   * If load_op is [`LoadOp::Clear`], the attachment will be cleared to this
   * color.
   */
  uint32_t clear_value;
  /**
   * If true, the relevant channel is not changed by a renderpass, and the
   * corresponding attachment can be used inside the pass by other read-only
   * usages.
   */
  bool read_only;
};

/**
 * Describes a depth/stencil attachment to a render pass.
 */
struct WGPURenderPassDepthStencilAttachment {
  /**
   * The view to use as an attachment.
   */
  WGPUTextureViewId view;
  /**
   * What operations will be performed on the depth part of the attachment.
   */
  struct WGPUPassChannel_f32 depth;
  /**
   * What operations will be performed on the stencil part of the attachment.
   */
  struct WGPUPassChannel_u32 stencil;
};

struct WGPURenderPassTimestampWrites {
  WGPUQuerySetId query_set;
  const uint32_t *beginning_of_pass_write_index;
  const uint32_t *end_of_pass_write_index;
};

struct WGPURenderPassDescriptor {
  const nsACString *label;
  const struct WGPURenderPassColorAttachment *color_attachments;
  uintptr_t color_attachments_length;
  const struct WGPURenderPassDepthStencilAttachment *depth_stencil_attachment;
  const struct WGPURenderPassTimestampWrites *timestamp_writes;
  WGPUOption_QuerySetId occlusion_query_set;
};

/**
 * Describes the shader stages that a binding will be visible from.
 *
 * These can be combined so something that is visible from both vertex and fragment shaders can be defined as:
 *
 * `ShaderStages::VERTEX | ShaderStages::FRAGMENT`
 *
 * Corresponds to [WebGPU `GPUShaderStageFlags`](
 * https://gpuweb.github.io/gpuweb/#typedefdef-gpushaderstageflags).
 */
typedef uint32_t WGPUShaderStages;
/**
 * Binding is not visible from any shader stage.
 */
#define WGPUShaderStages_NONE (uint32_t)0
/**
 * Binding is visible from the vertex shader of a render pipeline.
 */
#define WGPUShaderStages_VERTEX (uint32_t)(1 << 0)
/**
 * Binding is visible from the fragment shader of a render pipeline.
 */
#define WGPUShaderStages_FRAGMENT (uint32_t)(1 << 1)
/**
 * Binding is visible from the compute shader of a compute pipeline.
 */
#define WGPUShaderStages_COMPUTE (uint32_t)(1 << 2)
/**
 * Binding is visible from the vertex and fragment shaders of a render pipeline.
 */
#define WGPUShaderStages_VERTEX_FRAGMENT (uint32_t)((WGPUShaderStages_VERTEX).bits | (WGPUShaderStages_FRAGMENT).bits)

struct WGPUBindGroupLayoutEntry {
  uint32_t binding;
  WGPUShaderStages visibility;
  enum WGPURawBindingType ty;
  bool has_dynamic_offset;
  WGPUOption_BufferSize min_binding_size;
  const enum WGPUTextureViewDimension *view_dimension;
  const enum WGPURawTextureSampleType *texture_sample_type;
  bool multisampled;
  const struct WGPUTextureFormat *storage_texture_format;
  bool sampler_filter;
  bool sampler_compare;
};

struct WGPUBindGroupLayoutDescriptor {
  const nsACString *label;
  const struct WGPUBindGroupLayoutEntry *entries;
  uintptr_t entries_length;
};

struct WGPUPipelineLayoutDescriptor {
  const nsACString *label;
  const WGPUBindGroupLayoutId *bind_group_layouts;
  uintptr_t bind_group_layouts_length;
};

/**
 * Integral type used for buffer offsets.
 */
typedef uint64_t WGPUBufferAddress;

struct WGPUBindGroupEntry {
  uint32_t binding;
  WGPUOption_BufferId buffer;
  WGPUBufferAddress offset;
  WGPUOption_BufferSize size;
  WGPUOption_SamplerId sampler;
  WGPUOption_TextureViewId texture_view;
};

struct WGPUBindGroupDescriptor {
  const nsACString *label;
  WGPUBindGroupLayoutId layout;
  const struct WGPUBindGroupEntry *entries;
  uintptr_t entries_length;
};

typedef const char *WGPURawString;

struct WGPUConstantEntry {
  WGPURawString key;
  double value;
};

struct WGPUProgrammableStageDescriptor {
  WGPUShaderModuleId module;
  WGPURawString entry_point;
  const struct WGPUConstantEntry *constants;
  uintptr_t constants_length;
};

struct WGPUComputePipelineDescriptor {
  const nsACString *label;
  WGPUOption_PipelineLayoutId layout;
  struct WGPUProgrammableStageDescriptor stage;
};

/**
 * Integral type used for binding locations in shaders.
 */
typedef uint32_t WGPUShaderLocation;

/**
 * Vertex inputs (attributes) to shaders.
 *
 * Arrays of these can be made with the [`vertex_attr_array`]
 * macro. Vertex attributes are assumed to be tightly packed.
 *
 * Corresponds to [WebGPU `GPUVertexAttribute`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpuvertexattribute).
 *
 * [`vertex_attr_array`]: ../wgpu/macro.vertex_attr_array.html
 */
struct WGPUVertexAttribute {
  /**
   * Format of the input
   */
  enum WGPUVertexFormat format;
  /**
   * Byte offset of the start of the input
   */
  WGPUBufferAddress offset;
  /**
   * Location for this input. Must match the location in the shader.
   */
  WGPUShaderLocation shader_location;
};

struct WGPUVertexBufferLayout {
  WGPUBufferAddress array_stride;
  enum WGPUVertexStepMode step_mode;
  const struct WGPUVertexAttribute *attributes;
  uintptr_t attributes_length;
};

struct WGPUVertexState {
  struct WGPUProgrammableStageDescriptor stage;
  const struct WGPUVertexBufferLayout *buffers;
  uintptr_t buffers_length;
};

struct WGPUPrimitiveState {
  enum WGPUPrimitiveTopology topology;
  const enum WGPUIndexFormat *strip_index_format;
  enum WGPUFrontFace front_face;
  const enum WGPUFace *cull_mode;
  enum WGPUPolygonMode polygon_mode;
  bool unclipped_depth;
};

/**
 * Describes a blend component of a [`BlendState`].
 *
 * Corresponds to [WebGPU `GPUBlendComponent`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpublendcomponent).
 */
struct WGPUBlendComponent {
  /**
   * Multiplier for the source, which is produced by the fragment shader.
   */
  enum WGPUBlendFactor src_factor;
  /**
   * Multiplier for the destination, which is stored in the target.
   */
  enum WGPUBlendFactor dst_factor;
  /**
   * The binary operation applied to the source and destination,
   * multiplied by their respective factors.
   */
  enum WGPUBlendOperation operation;
};
/**
 * Default blending state that replaces destination with the source.
 */
#define WGPUBlendComponent_REPLACE (WGPUBlendComponent){ .src_factor = WGPUBlendFactor_One, .dst_factor = WGPUBlendFactor_Zero, .operation = WGPUBlendOperation_Add }
/**
 * Blend state of (1 * src) + ((1 - src_alpha) * dst)
 */
#define WGPUBlendComponent_OVER (WGPUBlendComponent){ .src_factor = WGPUBlendFactor_One, .dst_factor = WGPUBlendFactor_OneMinusSrcAlpha, .operation = WGPUBlendOperation_Add }

/**
 * Describe the blend state of a render pipeline,
 * within [`ColorTargetState`].
 *
 * See the OpenGL or Vulkan spec for more information.
 *
 * Corresponds to [WebGPU `GPUBlendState`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpublendstate).
 */
struct WGPUBlendState {
  /**
   * Color equation.
   */
  struct WGPUBlendComponent color;
  /**
   * Alpha equation.
   */
  struct WGPUBlendComponent alpha;
};
/**
 * Blend mode that does no color blending, just overwrites the output with the contents of the shader.
 */
#define WGPUBlendState_REPLACE (WGPUBlendState){ .color = WGPUBlendComponent_REPLACE, .alpha = WGPUBlendComponent_REPLACE }
/**
 * Blend mode that does standard alpha blending with non-premultiplied alpha.
 */
#define WGPUBlendState_ALPHA_BLENDING (WGPUBlendState){ .color = (WGPUBlendComponent){ .src_factor = WGPUBlendFactor_SrcAlpha, .dst_factor = WGPUBlendFactor_OneMinusSrcAlpha, .operation = WGPUBlendOperation_Add }, .alpha = WGPUBlendComponent_OVER }
/**
 * Blend mode that does standard alpha blending with premultiplied alpha.
 */
#define WGPUBlendState_PREMULTIPLIED_ALPHA_BLENDING (WGPUBlendState){ .color = WGPUBlendComponent_OVER, .alpha = WGPUBlendComponent_OVER }

/**
 * Color write mask. Disabled color channels will not be written to.
 *
 * Corresponds to [WebGPU `GPUColorWriteFlags`](
 * https://gpuweb.github.io/gpuweb/#typedefdef-gpucolorwriteflags).
 */
typedef uint32_t WGPUColorWrites;
/**
 * Enable red channel writes
 */
#define WGPUColorWrites_RED (uint32_t)(1 << 0)
/**
 * Enable green channel writes
 */
#define WGPUColorWrites_GREEN (uint32_t)(1 << 1)
/**
 * Enable blue channel writes
 */
#define WGPUColorWrites_BLUE (uint32_t)(1 << 2)
/**
 * Enable alpha channel writes
 */
#define WGPUColorWrites_ALPHA (uint32_t)(1 << 3)
/**
 * Enable red, green, and blue channel writes
 */
#define WGPUColorWrites_COLOR (uint32_t)(((WGPUColorWrites_RED).bits | (WGPUColorWrites_GREEN).bits) | (WGPUColorWrites_BLUE).bits)
/**
 * Enable writes to all channels.
 */
#define WGPUColorWrites_ALL (uint32_t)((((WGPUColorWrites_RED).bits | (WGPUColorWrites_GREEN).bits) | (WGPUColorWrites_BLUE).bits) | (WGPUColorWrites_ALPHA).bits)

struct WGPUColorTargetState {
  struct WGPUTextureFormat format;
  const struct WGPUBlendState *blend;
  WGPUColorWrites write_mask;
};

struct WGPUFragmentState {
  struct WGPUProgrammableStageDescriptor stage;
  const struct WGPUColorTargetState *targets;
  uintptr_t targets_length;
};

/**
 * Describes stencil state in a render pipeline.
 *
 * If you are not using stencil state, set this to [`StencilFaceState::IGNORE`].
 *
 * Corresponds to [WebGPU `GPUStencilFaceState`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpustencilfacestate).
 */
struct WGPUStencilFaceState {
  /**
   * Comparison function that determines if the fail_op or pass_op is used on the stencil buffer.
   */
  enum WGPUCompareFunction compare;
  /**
   * Operation that is preformed when stencil test fails.
   */
  enum WGPUStencilOperation fail_op;
  /**
   * Operation that is performed when depth test fails but stencil test succeeds.
   */
  enum WGPUStencilOperation depth_fail_op;
  /**
   * Operation that is performed when stencil test success.
   */
  enum WGPUStencilOperation pass_op;
};
/**
 * Ignore the stencil state for the face.
 */
#define WGPUStencilFaceState_IGNORE (WGPUStencilFaceState){ .compare = WGPUCompareFunction_Always, .fail_op = WGPUStencilOperation_Keep, .depth_fail_op = WGPUStencilOperation_Keep, .pass_op = WGPUStencilOperation_Keep }

/**
 * State of the stencil operation (fixed-pipeline stage).
 *
 * For use in [`DepthStencilState`].
 *
 * Corresponds to a portion of [WebGPU `GPUDepthStencilState`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpudepthstencilstate).
 */
struct WGPUStencilState {
  /**
   * Front face mode.
   */
  struct WGPUStencilFaceState front;
  /**
   * Back face mode.
   */
  struct WGPUStencilFaceState back;
  /**
   * Stencil values are AND'd with this mask when reading and writing from the stencil buffer. Only low 8 bits are used.
   */
  uint32_t read_mask;
  /**
   * Stencil values are AND'd with this mask when writing to the stencil buffer. Only low 8 bits are used.
   */
  uint32_t write_mask;
};

/**
 * Describes the biasing setting for the depth target.
 *
 * For use in [`DepthStencilState`].
 *
 * Corresponds to a portion of [WebGPU `GPUDepthStencilState`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpudepthstencilstate).
 */
struct WGPUDepthBiasState {
  /**
   * Constant depth biasing factor, in basic units of the depth format.
   */
  int32_t constant;
  /**
   * Slope depth biasing factor.
   */
  float slope_scale;
  /**
   * Depth bias clamp value (absolute).
   */
  float clamp;
};

/**
 * Describes the depth/stencil state in a render pipeline.
 *
 * Corresponds to [WebGPU `GPUDepthStencilState`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpudepthstencilstate).
 */
struct WGPUDepthStencilState {
  /**
   * Format of the depth/stencil buffer, must be special depth format. Must match the format
   * of the depth/stencil attachment in [`CommandEncoder::begin_render_pass`][CEbrp].
   *
   * [CEbrp]: ../wgpu/struct.CommandEncoder.html#method.begin_render_pass
   */
  struct WGPUTextureFormat format;
  /**
   * If disabled, depth will not be written to.
   */
  bool depth_write_enabled;
  /**
   * Comparison function used to compare depth values in the depth test.
   */
  enum WGPUCompareFunction depth_compare;
  /**
   * Stencil state.
   */
  struct WGPUStencilState stencil;
  /**
   * Depth bias state.
   */
  struct WGPUDepthBiasState bias;
};

/**
 * Describes the multi-sampling state of a render pipeline.
 *
 * Corresponds to [WebGPU `GPUMultisampleState`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpumultisamplestate).
 */
struct WGPUMultisampleState {
  /**
   * The number of samples calculated per pixel (for MSAA). For non-multisampled textures,
   * this should be `1`
   */
  uint32_t count;
  /**
   * Bitmask that restricts the samples of a pixel modified by this pipeline. All samples
   * can be enabled using the value `!0`
   */
  uint64_t mask;
  /**
   * When enabled, produces another sample mask per pixel based on the alpha output value, that
   * is ANDed with the sample_mask and the primitive coverage to restrict the set of samples
   * affected by a primitive.
   *
   * The implicit mask produced for alpha of zero is guaranteed to be zero, and for alpha of one
   * is guaranteed to be all 1-s.
   */
  bool alpha_to_coverage_enabled;
};

struct WGPURenderPipelineDescriptor {
  const nsACString *label;
  WGPUOption_PipelineLayoutId layout;
  const struct WGPUVertexState *vertex;
  struct WGPUPrimitiveState primitive;
  const struct WGPUFragmentState *fragment;
  const struct WGPUDepthStencilState *depth_stencil;
  struct WGPUMultisampleState multisample;
};

/**
 * Origin of a copy to/from a texture.
 *
 * Corresponds to [WebGPU `GPUOrigin3D`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpuorigin3ddict).
 */
struct WGPUOrigin3d {
  /**
   * X position of the origin
   */
  uint32_t x;
  /**
   * Y position of the origin
   */
  uint32_t y;
  /**
   * Z position of the origin
   */
  uint32_t z;
};
/**
 * Zero origin.
 */
#define WGPUOrigin3d_ZERO (WGPUOrigin3d){ .x = 0, .y = 0, .z = 0 }

/**
 * View of a texture which can be used to copy to/from a buffer/texture.
 *
 * Corresponds to [WebGPU `GPUImageCopyTexture`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpuimagecopytexture).
 */
struct WGPUImageCopyTexture_TextureId {
  /**
   * The texture to be copied to/from.
   */
  WGPUTextureId texture;
  /**
   * The target mip level of the texture.
   */
  uint32_t mip_level;
  /**
   * The base texel of the texture in the selected `mip_level`. Together
   * with the `copy_size` argument to copy functions, defines the
   * sub-region of the texture to copy.
   */
  struct WGPUOrigin3d origin;
  /**
   * The copy aspect.
   */
  enum WGPUTextureAspect aspect;
};

typedef struct WGPUImageCopyTexture_TextureId WGPUImageCopyTexture;

struct WGPUImageDataLayout {
  WGPUBufferAddress offset;
  const uint32_t *bytes_per_row;
  const uint32_t *rows_per_image;
};

/**
 * Integral type used for dynamic bind group offsets.
 */
typedef uint32_t WGPUDynamicOffset;

/**
 * Options for requesting adapter.
 *
 * Corresponds to [WebGPU `GPURequestAdapterOptions`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpurequestadapteroptions).
 */
struct WGPURequestAdapterOptions_SurfaceId {
  /**
   * Power preference for the adapter.
   */
  enum WGPUPowerPreference power_preference;
  /**
   * Indicates that only a fallback adapter can be returned. This is generally a "software"
   * implementation on the system.
   */
  bool force_fallback_adapter;
  /**
   * Surface that is required to be presentable with the requested adapter. This does not
   * create the surface, only guarantees that the adapter can present to said surface.
   */
  WGPUOption_SurfaceId compatible_surface;
};

typedef struct WGPURequestAdapterOptions_SurfaceId WGPURequestAdapterOptions;

struct WGPUFfiLUID {
  unsigned long low_part;
  long high_part;
};

/**
 * A non-owning representation of `mozilla::webgpu::ErrorBuffer` in C++, passed as an argument to
 * other functions in [this module](self).
 *
 * C++ callers of Rust functions (presumably in `WebGPUParent.cpp`) that expect one of these
 * structs can create a `mozilla::webgpu::ErrorBuffer` object, and call its `ToFFI` method to
 * construct a value of this type, available to C++ as `mozilla::webgpu::ffi::WGPUErrorBuffer`. If
 * we catch a `Result::Err` in other functions of [this module](self), the error is converted to
 * this type.
 */
struct WGPUErrorBuffer {
  /**
   * The type of error that `string` is associated with. If this location is set to
   * [`ErrorBufferType::None`] after being passed as an argument to a function in [this module](self),
   * then the remaining fields are guaranteed to not have been altered by that function from
   * their original state.
   */
  WGPUErrorBufferType *type;
  /**
   * The (potentially truncated) message associated with this error. A fixed-capacity,
   * null-terminated UTF-8 string buffer owned by C++.
   *
   * When we convert WGPU errors to this type, we render the error as a string, copying into
   * `message` up to `capacity - 1`, and null-terminate it.
   */
  char *message;
  uintptr_t message_capacity;
};

struct WGPUDeviceLostClosureC {
  void (*callback)(uint8_t *user_data,
                   uint8_t reason,
                   const char *message);
  uint8_t *user_data;
  bool consumed;
};

/**
 * A compilation message representation for the ffi boundary.
 * the message is immediately copied into an equivalent C++
 * structure that owns its strings.
 */
struct WGPUShaderModuleCompilationMessage {
  uint64_t line_number;
  uint64_t line_pos;
  uint64_t utf16_offset;
  uint64_t utf16_length;
  nsString message;
};

struct WGPUBufferMapCallbackC {
  void (*callback)(enum WGPUBufferMapAsyncStatus status,
                   uint8_t *user_data);
  uint8_t *user_data;
};

struct WGPUMappedBufferSlice {
  uint8_t *ptr;
  uint64_t length;
};

/**
 * Describes a [`CommandBuffer`](../wgpu/struct.CommandBuffer.html).
 *
 * Corresponds to [WebGPU `GPUCommandBufferDescriptor`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpucommandbufferdescriptor).
 */
struct WGPUCommandBufferDescriptor {
  /**
   * Debug label of this command buffer.
   */
  const nsACString *label;
};

struct WGPUSubmittedWorkDoneClosureC {
  void (*callback)(uint8_t *user_data);
  uint8_t *user_data;
};

struct WGPUMachTimebaseInfo {
  uint32_t numerator;
  uint32_t denominator;
};

/**
 * Different ways that you can use a buffer.
 *
 * The usages determine what kind of memory the buffer is allocated from and what
 * actions the buffer can partake in.
 *
 * Corresponds to [WebGPU `GPUBufferUsageFlags`](
 * https://gpuweb.github.io/gpuweb/#typedefdef-gpubufferusageflags).
 */
typedef uint32_t WGPUBufferUsages;
/**
 * Allow a buffer to be mapped for reading using [`Buffer::map_async`] + [`Buffer::get_mapped_range`].
 * This does not include creating a buffer with [`BufferDescriptor::mapped_at_creation`] set.
 *
 * If [`Features::MAPPABLE_PRIMARY_BUFFERS`] isn't enabled, the only other usage a buffer
 * may have is COPY_DST.
 */
#define WGPUBufferUsages_MAP_READ (uint32_t)(1 << 0)
/**
 * Allow a buffer to be mapped for writing using [`Buffer::map_async`] + [`Buffer::get_mapped_range_mut`].
 * This does not include creating a buffer with `mapped_at_creation` set.
 *
 * If [`Features::MAPPABLE_PRIMARY_BUFFERS`] feature isn't enabled, the only other usage a buffer
 * may have is COPY_SRC.
 */
#define WGPUBufferUsages_MAP_WRITE (uint32_t)(1 << 1)
/**
 * Allow a buffer to be the source buffer for a [`CommandEncoder::copy_buffer_to_buffer`] or [`CommandEncoder::copy_buffer_to_texture`]
 * operation.
 */
#define WGPUBufferUsages_COPY_SRC (uint32_t)(1 << 2)
/**
 * Allow a buffer to be the destination buffer for a [`CommandEncoder::copy_buffer_to_buffer`], [`CommandEncoder::copy_texture_to_buffer`],
 * [`CommandEncoder::clear_buffer`] or [`Queue::write_buffer`] operation.
 */
#define WGPUBufferUsages_COPY_DST (uint32_t)(1 << 3)
/**
 * Allow a buffer to be the index buffer in a draw operation.
 */
#define WGPUBufferUsages_INDEX (uint32_t)(1 << 4)
/**
 * Allow a buffer to be the vertex buffer in a draw operation.
 */
#define WGPUBufferUsages_VERTEX (uint32_t)(1 << 5)
/**
 * Allow a buffer to be a [`BufferBindingType::Uniform`] inside a bind group.
 */
#define WGPUBufferUsages_UNIFORM (uint32_t)(1 << 6)
/**
 * Allow a buffer to be a [`BufferBindingType::Storage`] inside a bind group.
 */
#define WGPUBufferUsages_STORAGE (uint32_t)(1 << 7)
/**
 * Allow a buffer to be the indirect buffer in an indirect draw call.
 */
#define WGPUBufferUsages_INDIRECT (uint32_t)(1 << 8)
/**
 * Allow a buffer to be the destination buffer for a [`CommandEncoder::resolve_query_set`] operation.
 */
#define WGPUBufferUsages_QUERY_RESOLVE (uint32_t)(1 << 9)

/**
 * We limit the size of buffer allocations for stability reason.
 * We can reconsider this limit in the future. Note that some drivers (mesa for example),
 * have issues when the size of a buffer, mapping or copy command does not fit into a
 * signed 32 bits integer, so beyond a certain size, large allocations will need some form
 * of driver allow/blocklist.
 */
#define WGPUMAX_BUFFER_SIZE (1ull << 30ull)

/**
 * Size of a single occlusion/timestamp query, when copied into a buffer, in bytes.
 */
#define WGPUQUERY_SIZE 8





































































































































































/**
 * An offset into the query resolve buffer has to be aligned to this.
 */
#define WGPUQUERY_RESOLVE_BUFFER_ALIGNMENT 256

/**
 * Buffer to buffer copy as well as buffer clear offsets and sizes must be aligned to this number.
 */
#define WGPUCOPY_BUFFER_ALIGNMENT 4

/**
 * Size to align mappings.
 */
#define WGPUMAP_ALIGNMENT 8

/**
 * Vertex buffer strides have to be aligned to this number.
 */
#define WGPUVERTEX_STRIDE_ALIGNMENT 4

































































#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

WGPU_INLINE
void wgpu_client_drop_action(struct WGPUClient *aClient,
                             const struct WGPUByteBuf *aByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_kill_device_id(const struct WGPUClient *aClient,
                                WGPUDeviceId aId)
WGPU_FUNC;

WGPU_INLINE
struct WGPUInfrastructure wgpu_client_new(void)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe because improper use may lead to memory
 * problems. For example, a double-free may occur if the function is called
 * twice on the same raw pointer.
 */
WGPU_INLINE
void wgpu_client_delete(struct WGPUClient *aClient)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given pointer is
 * valid for `id_length` elements.
 */
WGPU_INLINE
uintptr_t wgpu_client_make_adapter_ids(const struct WGPUClient *aClient,
                                       WGPUAdapterId *aIds,
                                       uintptr_t aIdLength)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_fill_default_limits(struct WGPULimits *aLimits)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_adapter_extract_info(const struct WGPUByteBuf *aByteBuf,
                                      struct WGPUAdapterInformation *aInfo)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_serialize_device_descriptor(const struct WGPUDeviceDescriptor *aDesc,
                                             struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
WGPUDeviceId wgpu_client_make_device_id(const struct WGPUClient *aClient,
                                        WGPUAdapterId aAdapterId)
WGPU_FUNC;

WGPU_INLINE
WGPUBufferId wgpu_client_make_buffer_id(const struct WGPUClient *aClient,
                                        WGPUDeviceId aDeviceId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_buffer_id(const struct WGPUClient *aClient,
                                WGPUBufferId aId)
WGPU_FUNC;

WGPU_INLINE
WGPUTextureId wgpu_client_create_texture(const struct WGPUClient *aClient,
                                         WGPUDeviceId aDeviceId,
                                         const struct WGPUTextureDescriptor *aDesc,
                                         const struct WGPUSwapChainId *aSwapChainId,
                                         struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_texture_id(const struct WGPUClient *aClient,
                                 WGPUTextureId aId)
WGPU_FUNC;

WGPU_INLINE
WGPUTextureViewId wgpu_client_create_texture_view(const struct WGPUClient *aClient,
                                                  WGPUDeviceId aDeviceId,
                                                  const struct WGPUTextureViewDescriptor *aDesc,
                                                  struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_texture_view_id(const struct WGPUClient *aClient,
                                      WGPUTextureViewId aId)
WGPU_FUNC;

WGPU_INLINE
WGPUSamplerId wgpu_client_create_sampler(const struct WGPUClient *aClient,
                                         WGPUDeviceId aDeviceId,
                                         const struct WGPUSamplerDescriptor *aDesc,
                                         struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_sampler_id(const struct WGPUClient *aClient,
                                 WGPUSamplerId aId)
WGPU_FUNC;

WGPU_INLINE
WGPUCommandEncoderId wgpu_client_make_encoder_id(const struct WGPUClient *aClient,
                                                 WGPUDeviceId aDeviceId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_command_encoder_id(const struct WGPUClient *aClient,
                                         WGPUCommandEncoderId aId)
WGPU_FUNC;

WGPU_INLINE
WGPUCommandEncoderId wgpu_client_create_command_encoder(const struct WGPUClient *aClient,
                                                        WGPUDeviceId aDeviceId,
                                                        const struct WGPUCommandEncoderDescriptor *aDesc,
                                                        struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
struct WGPURenderBundleEncoder *wgpu_device_create_render_bundle_encoder(WGPUDeviceId aDeviceId,
                                                                         const struct WGPURenderBundleEncoderDescriptor *aDesc,
                                                                         struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_encoder_destroy(struct WGPURenderBundleEncoder *aPass)
WGPU_FUNC;

WGPU_INLINE
WGPURenderBundleId wgpu_client_create_render_bundle(const struct WGPUClient *aClient,
                                                    struct WGPURenderBundleEncoder *aEncoder,
                                                    WGPUDeviceId aDeviceId,
                                                    const struct WGPURenderBundleDescriptor *aDesc,
                                                    struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
WGPURenderBundleId wgpu_client_create_render_bundle_error(const struct WGPUClient *aClient,
                                                          WGPUDeviceId aDeviceId,
                                                          const nsACString *aLabel,
                                                          struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_render_bundle_id(const struct WGPUClient *aClient,
                                       WGPURenderBundleId aId)
WGPU_FUNC;

WGPU_INLINE
struct WGPURecordedComputePass *wgpu_command_encoder_begin_compute_pass(const struct WGPUComputePassDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
void wgpu_compute_pass_finish(struct WGPURecordedComputePass *aPass,
                              struct WGPUByteBuf *aOutput)
WGPU_FUNC;

WGPU_INLINE
void wgpu_compute_pass_destroy(struct WGPURecordedComputePass *aPass)
WGPU_FUNC;

WGPU_INLINE
struct WGPURecordedRenderPass *wgpu_command_encoder_begin_render_pass(const struct WGPURenderPassDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_pass_finish(struct WGPURecordedRenderPass *aPass,
                             struct WGPUByteBuf *aOutput)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_pass_destroy(struct WGPURecordedRenderPass *aPass)
WGPU_FUNC;

WGPU_INLINE
WGPUBindGroupLayoutId wgpu_client_create_bind_group_layout(const struct WGPUClient *aClient,
                                                           WGPUDeviceId aDeviceId,
                                                           const struct WGPUBindGroupLayoutDescriptor *aDesc,
                                                           struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_bind_group_layout_id(const struct WGPUClient *aClient,
                                           WGPUBindGroupLayoutId aId)
WGPU_FUNC;

WGPU_INLINE
WGPUBindGroupLayoutId wgpu_client_render_pipeline_get_bind_group_layout(const struct WGPUClient *aClient,
                                                                        WGPURenderPipelineId aPipelineId,
                                                                        uint32_t aIndex,
                                                                        struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
WGPUBindGroupLayoutId wgpu_client_compute_pipeline_get_bind_group_layout(const struct WGPUClient *aClient,
                                                                         WGPUComputePipelineId aPipelineId,
                                                                         uint32_t aIndex,
                                                                         struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
WGPUPipelineLayoutId wgpu_client_create_pipeline_layout(const struct WGPUClient *aClient,
                                                        WGPUDeviceId aDeviceId,
                                                        const struct WGPUPipelineLayoutDescriptor *aDesc,
                                                        struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_pipeline_layout_id(const struct WGPUClient *aClient,
                                         WGPUPipelineLayoutId aId)
WGPU_FUNC;

WGPU_INLINE
WGPUBindGroupId wgpu_client_create_bind_group(const struct WGPUClient *aClient,
                                              WGPUDeviceId aDeviceId,
                                              const struct WGPUBindGroupDescriptor *aDesc,
                                              struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_bind_group_id(const struct WGPUClient *aClient,
                                    WGPUBindGroupId aId)
WGPU_FUNC;

WGPU_INLINE
WGPUShaderModuleId wgpu_client_make_shader_module_id(const struct WGPUClient *aClient,
                                                     WGPUDeviceId aDeviceId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_shader_module_id(const struct WGPUClient *aClient,
                                       WGPUShaderModuleId aId)
WGPU_FUNC;

WGPU_INLINE
WGPUComputePipelineId wgpu_client_create_compute_pipeline(const struct WGPUClient *aClient,
                                                          WGPUDeviceId aDeviceId,
                                                          const struct WGPUComputePipelineDescriptor *aDesc,
                                                          struct WGPUByteBuf *aBb,
                                                          WGPUOption_PipelineLayoutId *aImplicitPipelineLayoutId,
                                                          WGPUOption_BindGroupLayoutId *aImplicitBindGroupLayoutIds)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_compute_pipeline_id(const struct WGPUClient *aClient,
                                          WGPUComputePipelineId aId)
WGPU_FUNC;

WGPU_INLINE
WGPURenderPipelineId wgpu_client_create_render_pipeline(const struct WGPUClient *aClient,
                                                        WGPUDeviceId aDeviceId,
                                                        const struct WGPURenderPipelineDescriptor *aDesc,
                                                        struct WGPUByteBuf *aBb,
                                                        WGPUOption_PipelineLayoutId *aImplicitPipelineLayoutId,
                                                        WGPUOption_BindGroupLayoutId *aImplicitBindGroupLayoutIds)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_render_pipeline_id(const struct WGPUClient *aClient,
                                         WGPURenderPipelineId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_copy_buffer_to_buffer(WGPUBufferId aSrc,
                                                WGPUBufferAddress aSrcOffset,
                                                WGPUBufferId aDst,
                                                WGPUBufferAddress aDstOffset,
                                                WGPUBufferAddress aSize,
                                                struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_copy_texture_to_buffer(WGPUImageCopyTexture aSrc,
                                                 WGPUBufferId aDstBuffer,
                                                 const struct WGPUImageDataLayout *aDstLayout,
                                                 struct WGPUExtent3d aSize,
                                                 struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_copy_buffer_to_texture(WGPUBufferId aSrcBuffer,
                                                 const struct WGPUImageDataLayout *aSrcLayout,
                                                 WGPUImageCopyTexture aDst,
                                                 struct WGPUExtent3d aSize,
                                                 struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_copy_texture_to_texture(WGPUImageCopyTexture aSrc,
                                                  WGPUImageCopyTexture aDst,
                                                  struct WGPUExtent3d aSize,
                                                  struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_clear_buffer(WGPUBufferId aDst,
                                       uint64_t aOffset,
                                       const uint64_t *aSize,
                                       struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_push_debug_group(const nsACString *aMarker,
                                           struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_pop_debug_group(struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_insert_debug_marker(const nsACString *aMarker,
                                              struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_queue_write_buffer(WGPUBufferId aDst,
                             WGPUBufferAddress aOffset,
                             struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_queue_write_texture(struct WGPUImageCopyTexture_TextureId aDst,
                              struct WGPUImageDataLayout aLayout,
                              struct WGPUExtent3d aSize,
                              struct WGPUByteBuf *aBb)
WGPU_FUNC;

/**
 * Returns the block size or zero if the format has multiple aspects (for example depth+stencil).
 */
WGPU_INLINE
uint32_t wgpu_texture_format_block_size_single_aspect(struct WGPUTextureFormat aFormat)
WGPU_FUNC;

WGPU_INLINE
bool wgpu_client_use_external_texture_in_swapChain(WGPUDeviceId aDeviceId,
                                                   struct WGPUTextureFormat aFormat)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given pointer is
 * valid for `offset_length` elements.
 */
WGPU_INLINE
void wgpu_recorded_render_pass_set_bind_group(struct WGPURecordedRenderPass *aPass,
                                              uint32_t aIndex,
                                              WGPUBindGroupId aBindGroupId,
                                              const WGPUDynamicOffset *aOffsets,
                                              uintptr_t aOffsetLength)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_pipeline(struct WGPURecordedRenderPass *aPass,
                                            WGPURenderPipelineId aPipelineId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_vertex_buffer(struct WGPURecordedRenderPass *aPass,
                                                 uint32_t aSlot,
                                                 WGPUBufferId aBufferId,
                                                 WGPUBufferAddress aOffset,
                                                 WGPUOption_BufferSize aSize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_index_buffer(struct WGPURecordedRenderPass *aPass,
                                                WGPUBufferId aBufferId,
                                                enum WGPUIndexFormat aIndexFormat,
                                                WGPUBufferAddress aOffset,
                                                WGPUOption_BufferSize aSize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_blend_constant(struct WGPURecordedRenderPass *aPass,
                                                  const struct WGPUColor *aColor)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_stencil_reference(struct WGPURecordedRenderPass *aPass,
                                                     uint32_t aValue)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_viewport(struct WGPURecordedRenderPass *aPass,
                                            float aX,
                                            float aY,
                                            float aW,
                                            float aH,
                                            float aDepthMin,
                                            float aDepthMax)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_scissor_rect(struct WGPURecordedRenderPass *aPass,
                                                uint32_t aX,
                                                uint32_t aY,
                                                uint32_t aW,
                                                uint32_t aH)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_draw(struct WGPURecordedRenderPass *aPass,
                                    uint32_t aVertexCount,
                                    uint32_t aInstanceCount,
                                    uint32_t aFirstVertex,
                                    uint32_t aFirstInstance)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_draw_indexed(struct WGPURecordedRenderPass *aPass,
                                            uint32_t aIndexCount,
                                            uint32_t aInstanceCount,
                                            uint32_t aFirstIndex,
                                            int32_t aBaseVertex,
                                            uint32_t aFirstInstance)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_draw_indirect(struct WGPURecordedRenderPass *aPass,
                                             WGPUBufferId aBufferId,
                                             WGPUBufferAddress aOffset)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_draw_indexed_indirect(struct WGPURecordedRenderPass *aPass,
                                                     WGPUBufferId aBufferId,
                                                     WGPUBufferAddress aOffset)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_multi_draw_indirect(struct WGPURecordedRenderPass *aPass,
                                                   WGPUBufferId aBufferId,
                                                   WGPUBufferAddress aOffset,
                                                   uint32_t aCount)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_multi_draw_indexed_indirect(struct WGPURecordedRenderPass *aPass,
                                                           WGPUBufferId aBufferId,
                                                           WGPUBufferAddress aOffset,
                                                           uint32_t aCount)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_multi_draw_indirect_count(struct WGPURecordedRenderPass *aPass,
                                                         WGPUBufferId aBufferId,
                                                         WGPUBufferAddress aOffset,
                                                         WGPUBufferId aCountBufferId,
                                                         WGPUBufferAddress aCountBufferOffset,
                                                         uint32_t aMaxCount)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_multi_draw_indexed_indirect_count(struct WGPURecordedRenderPass *aPass,
                                                                 WGPUBufferId aBufferId,
                                                                 WGPUBufferAddress aOffset,
                                                                 WGPUBufferId aCountBufferId,
                                                                 WGPUBufferAddress aCountBufferOffset,
                                                                 uint32_t aMaxCount)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given `label`
 * is a valid null-terminated string.
 */
WGPU_INLINE
void wgpu_recorded_render_pass_push_debug_group(struct WGPURecordedRenderPass *aPass,
                                                WGPURawString aLabel,
                                                uint32_t aColor)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_pop_debug_group(struct WGPURecordedRenderPass *aPass)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given `label`
 * is a valid null-terminated string.
 */
WGPU_INLINE
void wgpu_recorded_render_pass_insert_debug_marker(struct WGPURecordedRenderPass *aPass,
                                                   WGPURawString aLabel,
                                                   uint32_t aColor)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_write_timestamp(struct WGPURecordedRenderPass *aPass,
                                               WGPUQuerySetId aQuerySetId,
                                               uint32_t aQueryIndex)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_begin_occlusion_query(struct WGPURecordedRenderPass *aPass,
                                                     uint32_t aQueryIndex)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_end_occlusion_query(struct WGPURecordedRenderPass *aPass)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_begin_pipeline_statistics_query(struct WGPURecordedRenderPass *aPass,
                                                               WGPUQuerySetId aQuerySetId,
                                                               uint32_t aQueryIndex)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_end_pipeline_statistics_query(struct WGPURecordedRenderPass *aPass)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given pointer is
 * valid for `render_bundle_ids_length` elements.
 */
WGPU_INLINE
void wgpu_recorded_render_pass_execute_bundles(struct WGPURecordedRenderPass *aPass,
                                               const WGPURenderBundleId *aRenderBundleIds,
                                               uintptr_t aRenderBundleIdsLength)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given pointer is
 * valid for `offset_length` elements.
 */
WGPU_INLINE
void wgpu_recorded_compute_pass_set_bind_group(struct WGPURecordedComputePass *aPass,
                                               uint32_t aIndex,
                                               WGPUBindGroupId aBindGroupId,
                                               const WGPUDynamicOffset *aOffsets,
                                               uintptr_t aOffsetLength)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_set_pipeline(struct WGPURecordedComputePass *aPass,
                                             WGPUComputePipelineId aPipelineId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_dispatch_workgroups(struct WGPURecordedComputePass *aPass,
                                                    uint32_t aGroupsX,
                                                    uint32_t aGroupsY,
                                                    uint32_t aGroupsZ)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_dispatch_workgroups_indirect(struct WGPURecordedComputePass *aPass,
                                                             WGPUBufferId aBufferId,
                                                             WGPUBufferAddress aOffset)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given `label`
 * is a valid null-terminated string.
 */
WGPU_INLINE
void wgpu_recorded_compute_pass_push_debug_group(struct WGPURecordedComputePass *aPass,
                                                 WGPURawString aLabel,
                                                 uint32_t aColor)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_pop_debug_group(struct WGPURecordedComputePass *aPass)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given `label`
 * is a valid null-terminated string.
 */
WGPU_INLINE
void wgpu_recorded_compute_pass_insert_debug_marker(struct WGPURecordedComputePass *aPass,
                                                    WGPURawString aLabel,
                                                    uint32_t aColor)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_write_timestamp(struct WGPURecordedComputePass *aPass,
                                                WGPUQuerySetId aQuerySetId,
                                                uint32_t aQueryIndex)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_begin_pipeline_statistics_query(struct WGPURecordedComputePass *aPass,
                                                                WGPUQuerySetId aQuerySetId,
                                                                uint32_t aQueryIndex)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_end_pipeline_statistics_query(struct WGPURecordedComputePass *aPass)
WGPU_FUNC;

WGPU_INLINE
struct WGPUGlobal *wgpu_server_new(void *aOwner)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe because improper use may lead to memory
 * problems. For example, a double-free may occur if the function is called
 * twice on the same raw pointer.
 */
WGPU_INLINE
void wgpu_server_delete(struct WGPUGlobal *aGlobal)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_poll_all_devices(const struct WGPUGlobal *aGlobal,
                                  bool aForceWait)
WGPU_FUNC;

/**
 * Request an adapter according to the specified options.
 * Provide the list of IDs to pick from.
 *
 * Returns the index in this list, or -1 if unable to pick.
 *
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given pointer is
 * valid for `id_length` elements.
 */
WGPU_INLINE
int8_t wgpu_server_instance_request_adapter(const struct WGPUGlobal *aGlobal,
                                            const WGPURequestAdapterOptions *aDesc,
                                            const WGPUAdapterId *aIds,
                                            uintptr_t aIdLength,
                                            const struct WGPUFfiLUID *aAdapterLuid,
                                            struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_adapter_pack_info(const struct WGPUGlobal *aGlobal,
                                   WGPUOption_AdapterId aSelfId,
                                   struct WGPUByteBuf *aByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_adapter_request_device(const struct WGPUGlobal *aGlobal,
                                        WGPUAdapterId aSelfId,
                                        const struct WGPUByteBuf *aByteBuf,
                                        WGPUDeviceId aNewId,
                                        struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_adapter_drop(const struct WGPUGlobal *aGlobal,
                              WGPUAdapterId aAdapterId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_device_destroy(const struct WGPUGlobal *aGlobal,
                                WGPUDeviceId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_device_drop(const struct WGPUGlobal *aGlobal,
                             WGPUDeviceId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_set_device_lost_callback(const struct WGPUGlobal *aGlobal,
                                          WGPUDeviceId aSelfId,
                                          struct WGPUDeviceLostClosureC aCallback)
WGPU_FUNC;

/**
 * Creates a shader module and returns an object describing the errors if any.
 *
 * If there was no error, the returned pointer is nil.
 */
WGPU_INLINE
bool wgpu_server_device_create_shader_module(const struct WGPUGlobal *aGlobal,
                                             WGPUDeviceId aSelfId,
                                             WGPUShaderModuleId aModuleId,
                                             const nsACString *aLabel,
                                             const nsCString *aCode,
                                             struct WGPUShaderModuleCompilationMessage *aOutMessage,
                                             struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_device_create_buffer(const struct WGPUGlobal *aGlobal,
                                      WGPUDeviceId aSelfId,
                                      WGPUBufferId aBufferId,
                                      const nsACString *aLabel,
                                      WGPUBufferAddress aSize,
                                      uint32_t aUsage,
                                      bool aMappedAtCreation,
                                      bool aShmAllocationFailed,
                                      struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

/**
 * # Safety
 *
 * Callers are responsible for ensuring `callback` is well-formed.
 */
WGPU_INLINE
void wgpu_server_buffer_map(const struct WGPUGlobal *aGlobal,
                            WGPUBufferId aBufferId,
                            WGPUBufferAddress aStart,
                            WGPUBufferAddress aSize,
                            enum WGPUHostMap aMapMode,
                            struct WGPUBufferMapCallbackC aCallback,
                            struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given pointer is
 * valid for `size` elements.
 */
WGPU_INLINE
struct WGPUMappedBufferSlice wgpu_server_buffer_get_mapped_range(const struct WGPUGlobal *aGlobal,
                                                                 WGPUBufferId aBufferId,
                                                                 WGPUBufferAddress aStart,
                                                                 WGPUBufferAddress aSize,
                                                                 struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_buffer_unmap(const struct WGPUGlobal *aGlobal,
                              WGPUBufferId aBufferId,
                              struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_buffer_destroy(const struct WGPUGlobal *aGlobal,
                                WGPUBufferId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_buffer_drop(const struct WGPUGlobal *aGlobal,
                             WGPUBufferId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void *wgpu_server_get_device_fence_handle(const struct WGPUGlobal *aGlobal,
                                          WGPUDeviceId aDeviceId)
WGPU_FUNC;

extern bool wgpu_server_use_external_texture_for_swap_chain(void *aParam,
                                                            struct WGPUSwapChainId aSwapChainId);

extern bool wgpu_server_ensure_external_texture_for_swap_chain(void *aParam,
                                                               struct WGPUSwapChainId aSwapChainId,
                                                               WGPUDeviceId aDeviceId,
                                                               WGPUTextureId aTextureId,
                                                               uint32_t aWidth,
                                                               uint32_t aHeight,
                                                               struct WGPUTextureFormat aFormat,
                                                               WGPUTextureUsages aUsage);

extern void *wgpu_server_get_external_texture_handle(void *aParam,
                                                     WGPUTextureId aId);

WGPU_INLINE
void wgpu_server_device_action(const struct WGPUGlobal *aGlobal,
                               WGPUDeviceId aSelfId,
                               const struct WGPUByteBuf *aByteBuf,
                               struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_texture_action(const struct WGPUGlobal *aGlobal,
                                WGPUTextureId aSelfId,
                                const struct WGPUByteBuf *aByteBuf,
                                struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_command_encoder_action(const struct WGPUGlobal *aGlobal,
                                        WGPUCommandEncoderId aSelfId,
                                        const struct WGPUByteBuf *aByteBuf,
                                        struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_render_pass(const struct WGPUGlobal *aGlobal,
                             WGPUCommandEncoderId aEncoderId,
                             const struct WGPUByteBuf *aByteBuf,
                             struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_compute_pass(const struct WGPUGlobal *aGlobal,
                              WGPUCommandEncoderId aEncoderId,
                              const struct WGPUByteBuf *aByteBuf,
                              struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_device_create_encoder(const struct WGPUGlobal *aGlobal,
                                       WGPUDeviceId aSelfId,
                                       const struct WGPUCommandEncoderDescriptor *aDesc,
                                       WGPUCommandEncoderId aNewId,
                                       struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_encoder_finish(const struct WGPUGlobal *aGlobal,
                                WGPUCommandEncoderId aSelfId,
                                const struct WGPUCommandBufferDescriptor *aDesc,
                                struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_encoder_drop(const struct WGPUGlobal *aGlobal,
                              WGPUCommandEncoderId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_render_bundle_drop(const struct WGPUGlobal *aGlobal,
                                    WGPURenderBundleId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_encoder_copy_texture_to_buffer(const struct WGPUGlobal *aGlobal,
                                                WGPUCommandEncoderId aSelfId,
                                                const WGPUImageCopyTexture *aSource,
                                                WGPUBufferId aDstBuffer,
                                                const struct WGPUImageDataLayout *aDstLayout,
                                                const struct WGPUExtent3d *aSize,
                                                struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given pointer is
 * valid for `command_buffer_id_length` elements.
 */
WGPU_INLINE
uint64_t wgpu_server_queue_submit(const struct WGPUGlobal *aGlobal,
                                  WGPUQueueId aSelfId,
                                  const WGPUCommandBufferId *aCommandBufferIds,
                                  uintptr_t aCommandBufferIdLength,
                                  struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_on_submitted_work_done(const struct WGPUGlobal *aGlobal,
                                        WGPUQueueId aSelfId,
                                        struct WGPUSubmittedWorkDoneClosureC aCallback)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given pointer is
 * valid for `data_length` elements.
 */
WGPU_INLINE
void wgpu_server_queue_write_action(const struct WGPUGlobal *aGlobal,
                                    WGPUQueueId aSelfId,
                                    const struct WGPUByteBuf *aByteBuf,
                                    const uint8_t *aData,
                                    uintptr_t aDataLength,
                                    struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_bind_group_layout_drop(const struct WGPUGlobal *aGlobal,
                                        WGPUBindGroupLayoutId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_pipeline_layout_drop(const struct WGPUGlobal *aGlobal,
                                      WGPUPipelineLayoutId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_bind_group_drop(const struct WGPUGlobal *aGlobal,
                                 WGPUBindGroupId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_shader_module_drop(const struct WGPUGlobal *aGlobal,
                                    WGPUShaderModuleId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_compute_pipeline_drop(const struct WGPUGlobal *aGlobal,
                                       WGPUComputePipelineId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_render_pipeline_drop(const struct WGPUGlobal *aGlobal,
                                      WGPURenderPipelineId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_texture_destroy(const struct WGPUGlobal *aGlobal,
                                 WGPUTextureId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_texture_drop(const struct WGPUGlobal *aGlobal,
                              WGPUTextureId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_texture_view_drop(const struct WGPUGlobal *aGlobal,
                                   WGPUTextureViewId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_sampler_drop(const struct WGPUGlobal *aGlobal,
                              WGPUSamplerId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_compute_pipeline_get_bind_group_layout(const struct WGPUGlobal *aGlobal,
                                                        WGPUComputePipelineId aSelfId,
                                                        uint32_t aIndex,
                                                        WGPUBindGroupLayoutId aAssignId,
                                                        struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_render_pipeline_get_bind_group_layout(const struct WGPUGlobal *aGlobal,
                                                       WGPURenderPipelineId aSelfId,
                                                       uint32_t aIndex,
                                                       WGPUBindGroupLayoutId aAssignId,
                                                       struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

/**
 * Encode the freeing of the selected ID into a byte buf.
 */
WGPU_INLINE
void wgpu_server_adapter_free(WGPUAdapterId aId,
                              struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_device_free(WGPUDeviceId aId,
                             struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_shader_module_free(WGPUShaderModuleId aId,
                                    struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_pipeline_layout_free(WGPUPipelineLayoutId aId,
                                      struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_bind_group_layout_free(WGPUBindGroupLayoutId aId,
                                        struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_bind_group_free(WGPUBindGroupId aId,
                                 struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_command_buffer_free(WGPUCommandBufferId aId,
                                     struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_render_bundle_free(WGPURenderBundleId aId,
                                    struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_render_pipeline_free(WGPURenderPipelineId aId,
                                      struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_compute_pipeline_free(WGPUComputePipelineId aId,
                                       struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_buffer_free(WGPUBufferId aId,
                             struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_texture_free(WGPUTextureId aId,
                              struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_texture_view_free(WGPUTextureViewId aId,
                                   struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_sampler_free(WGPUSamplerId aId,
                              struct WGPUByteBuf *aDropByteBuf)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given pointer is
 * valid for `offset_length` elements.
 */
WGPU_INLINE
void wgpu_render_bundle_set_bind_group(struct WGPURenderBundleEncoder *aBundle,
                                       uint32_t aIndex,
                                       WGPUBindGroupId aBindGroupId,
                                       const WGPUDynamicOffset *aOffsets,
                                       uintptr_t aOffsetLength)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_set_pipeline(struct WGPURenderBundleEncoder *aBundle,
                                     WGPURenderPipelineId aPipelineId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_set_vertex_buffer(struct WGPURenderBundleEncoder *aBundle,
                                          uint32_t aSlot,
                                          WGPUBufferId aBufferId,
                                          WGPUBufferAddress aOffset,
                                          WGPUOption_BufferSize aSize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_set_index_buffer(struct WGPURenderBundleEncoder *aEncoder,
                                         WGPUBufferId aBuffer,
                                         enum WGPUIndexFormat aIndexFormat,
                                         WGPUBufferAddress aOffset,
                                         WGPUOption_BufferSize aSize)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given pointer is
 * valid for `data` elements.
 */
WGPU_INLINE
void wgpu_render_bundle_set_push_constants(struct WGPURenderBundleEncoder *aPass,
                                           WGPUShaderStages aStages,
                                           uint32_t aOffset,
                                           uint32_t aSizeBytes,
                                           const uint8_t *aData)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_draw(struct WGPURenderBundleEncoder *aBundle,
                             uint32_t aVertexCount,
                             uint32_t aInstanceCount,
                             uint32_t aFirstVertex,
                             uint32_t aFirstInstance)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_draw_indexed(struct WGPURenderBundleEncoder *aBundle,
                                     uint32_t aIndexCount,
                                     uint32_t aInstanceCount,
                                     uint32_t aFirstIndex,
                                     int32_t aBaseVertex,
                                     uint32_t aFirstInstance)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_draw_indirect(struct WGPURenderBundleEncoder *aBundle,
                                      WGPUBufferId aBufferId,
                                      WGPUBufferAddress aOffset)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_draw_indexed_indirect(struct WGPURenderBundleEncoder *aBundle,
                                              WGPUBufferId aBufferId,
                                              WGPUBufferAddress aOffset)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given `label`
 * is a valid null-terminated string.
 */
WGPU_INLINE
void wgpu_render_bundle_push_debug_group(struct WGPURenderBundleEncoder *aBundle,
                                         WGPURawString aLabel)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_pop_debug_group(struct WGPURenderBundleEncoder *aBundle)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given `label`
 * is a valid null-terminated string.
 */
WGPU_INLINE
void wgpu_render_bundle_insert_debug_marker(struct WGPURenderBundleEncoder *aBundle,
                                            WGPURawString aLabel)
WGPU_FUNC;

/**
 * returns 1 if success. 0 if failure. extension name must be null terminated
 */
extern int emscripten_webgl_enable_extension(int aContext,
                                             const char *aExtension);

extern int emscripten_webgl_get_current_context(void);

extern uint32_t mach_timebase_info(struct WGPUMachTimebaseInfo *aOut);

extern uint64_t mach_absolute_time(void);

#ifdef __cplusplus
} // extern "C"
#endif // __cplusplus
