// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanSearchMetrics_h
#define mozilla_GleanSearchMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace newtab_search {
  /**
   * generated from newtab.search.issued
   */
  struct IssuedExtra {
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> searchAccessPoint;
    mozilla::Maybe<nsCString> telemetryId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (searchAccessPoint) {
        extraKeys.AppendElement()->AssignASCII("search_access_point");
        extraValues.EmplaceBack(searchAccessPoint.value());
      }
      if (telemetryId) {
        extraKeys.AppendElement()->AssignASCII("telemetry_id");
        extraValues.EmplaceBack(telemetryId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * When Firefox was asked to issue a search from a Search Access Point (SAP) on a newtab page. Doesn't record searches in Private Browsing Mode unless `browser.engagement.search_counts.pbm` is set to `true`.
   */
  constexpr impl::EventMetric<IssuedExtra> issued(575);
}

namespace browser_engagement_navigation {
  /**
   * generated from browser.engagement.navigation.about_home
   * The count URI loads triggered in a subsession from about:home, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.about_home.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> about_home(730);

  /**
   * generated from browser.engagement.navigation.about_newtab
   * The count URI loads triggered in a subsession from about:newtab, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.about_newtab.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> about_newtab(731);

  /**
   * generated from browser.engagement.navigation.contextmenu
   * The count URI loads triggered in a subsession from the contextmenu, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.contextmenu.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> contextmenu(732);

  /**
   * generated from browser.engagement.navigation.searchbar
   * The count URI loads triggered in a subsession from the searchbar, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.searchbar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> searchbar(733);

  /**
   * generated from browser.engagement.navigation.urlbar
   * The count URI loads triggered in a subsession from the urlbar, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.urlbar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar(734);

  /**
   * generated from browser.engagement.navigation.urlbar_handoff
   * The count URI loads triggered in a subsession from the urlbar via handoff, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.urlbar_handoff.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar_handoff(735);

  /**
   * generated from browser.engagement.navigation.urlbar_persisted
   * The count of URI loads triggered in a subsession from the urlbar after the search term was shown in the urlbar, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.urlbar_persisted.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar_persisted(736);

  /**
   * generated from browser.engagement.navigation.urlbar_searchmode
   * The count URI loads triggered in a subsession from the urlbar's search mode, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.urlbar_searchmode.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar_searchmode(737);

  /**
   * generated from browser.engagement.navigation.webextension
   * The count URI loads triggered in a subsession from a webextension. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.webextension.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> webextension(738);
}

namespace browser_search_adclicks {
  /**
   * generated from browser.search.adclicks.about_home
   * Records clicks of adverts on SERP pages where the search was started from about:home. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source- docs.mozilla.org/browser/search/telemetry.html#browser-search- content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.about_home.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> about_home(739);

  /**
   * generated from browser.search.adclicks.about_newtab
   * Records clicks of adverts on SERP pages where the search was started from about:newtab. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.about_newtab.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> about_newtab(740);

  /**
   * generated from browser.search.adclicks.contextmenu
   * Records clicks of adverts on SERP pages where the search was started from the context menu. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.contextmenu.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> contextmenu(741);

  /**
   * generated from browser.search.adclicks.reload
   * Records clicks of adverts on SERP pages where the search was loaded by reloading the page. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.reload.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> reload(742);

  /**
   * generated from browser.search.adclicks.searchbar
   * Records clicks of adverts on SERP pages where the search was started from the search bar. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.searchbar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> searchbar(743);

  /**
   * generated from browser.search.adclicks.system
   * Records clicks of adverts on SERP pages where the search was started from the system, e.g. command line. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.system.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> system(744);

  /**
   * generated from browser.search.adclicks.tabhistory
   * Records clicks of adverts on SERP pages where the search was loaded from the tab history. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.tabhistory.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> tabhistory(745);

  /**
   * generated from browser.search.adclicks.unknown
   * Records clicks of adverts on SERP pages where the search was started from a place not categorized by the other scalars. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.unknown.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> unknown(746);

  /**
   * generated from browser.search.adclicks.urlbar
   * Records clicks of adverts on SERP pages where the search was started from the urlbar. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source- docs.mozilla.org/browser/search/telemetry.html#browser-search- content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.urlbar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar(747);

  /**
   * generated from browser.search.adclicks.urlbar_handoff
   * The count URI loads triggered in a subsession from the urlbar via handoff, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.urlbar_handoff.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar_handoff(748);

  /**
   * generated from browser.search.adclicks.urlbar_persisted
   * Records clicks of adverts on SERP pages where the search was started from the urlbar after the search term was shown in the urlbar. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.urlbar_persisted.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar_persisted(749);

  /**
   * generated from browser.search.adclicks.urlbar_searchmode
   * Records clicks of adverts on SERP pages where the search was started from the urlbar in search mode. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.urlbar_searchmode.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar_searchmode(750);

  /**
   * generated from browser.search.adclicks.webextension
   * Records clicks of adverts on SERP pages where the search was started from a webextension. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.webextension.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> webextension(751);
}

namespace browser_search_content {
  /**
   * generated from browser.search.content.about_home
   * Records counts for in-content searches where the search was most likely started from the about:home. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.about_home.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> about_home(752);

  /**
   * generated from browser.search.content.about_newtab
   * Records counts for in-content searches where the search was most likely started from the about:newtab. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.about_newtab.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> about_newtab(753);

  /**
   * generated from browser.search.content.contextmenu
   * Records counts for in-content searches where the search was most likely started from the context menu. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.contextmenu.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> contextmenu(754);

  /**
   * generated from browser.search.content.reload
   * Records counts for in-content searches where the search was loaded by reloading the page. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.reload.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> reload(755);

  /**
   * generated from browser.search.content.searchbar
   * Records counts for in-content searches where the search was most likely started from the search bar. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.searchbar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> searchbar(756);

  /**
   * generated from browser.search.content.system
   * Records counts for in-content searches where the search was most likely started from the system, e.g. command line. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.system.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> system(757);

  /**
   * generated from browser.search.content.tabhistory
   * Records counts for in-content searches where the search was loaded from the tab history. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.tabhistory.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> tabhistory(758);

  /**
   * generated from browser.search.content.unknown
   * Records counts for in-content searches where the search was started from a place that could not be determined or not categorized by the other scalars. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.unknown.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> unknown(759);

  /**
   * generated from browser.search.content.urlbar
   * Records counts for in-content searches where the search was most likely started from the urlbar. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.urlbar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar(760);

  /**
   * generated from browser.search.content.urlbar_handoff
   * The count URI loads triggered in a subsession from the urlbar via handoff, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.urlbar_handoff.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar_handoff(761);

  /**
   * generated from browser.search.content.urlbar_persisted
   * Records counts for in-content searches where the search was most likely started from the urlbar after the search term was shown in the urlbar. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.urlbar_persisted.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar_persisted(762);

  /**
   * generated from browser.search.content.urlbar_searchmode
   * Records counts for in-content searches where the search was most likely started from the urlbar in search mode. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.urlbar_searchmode.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar_searchmode(763);

  /**
   * generated from browser.search.content.webextension
   * Records counts for in-content searches where the search was most likely started from a webextension. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.webextension.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> webextension(764);
}

namespace browser_search_withads {
  /**
   * generated from browser.search.withads.about_home
   * Records counts of SERP pages with adverts displayed where the search was started from about:home. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.about_home.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> about_home(765);

  /**
   * generated from browser.search.withads.about_newtab
   * Records counts of SERP pages with adverts displayed where the search was started from about:newtab. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.about_newtab.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> about_newtab(766);

  /**
   * generated from browser.search.withads.contextmenu
   * Records counts of SERP pages with adverts displayed where the search was started from the context menu. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.contextmenu.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> contextmenu(767);

  /**
   * generated from browser.search.withads.reload
   * Records counts of SERP pages with adverts displayed where the search was loaded by reloading the page. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.reload.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> reload(768);

  /**
   * generated from browser.search.withads.searchbar
   * Records counts of SERP pages with adverts displayed where the search was started from the search bar. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.searchbar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> searchbar(769);

  /**
   * generated from browser.search.withads.system
   * Records counts of SERP pages with adverts displayed where the search was started from the system, e.g. command line. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.system.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> system(770);

  /**
   * generated from browser.search.withads.tabhistory
   * Records counts of SERP pages with adverts displayed where the search was loaded from the tab history. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.tabhistory.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> tabhistory(771);

  /**
   * generated from browser.search.withads.unknown
   * Records counts of SERP pages with adverts displayed where the search was started from a place not categorized by the other scalars. The key format is ‘<provider>:<tagged|organic>’ See https://firefox- source-docs.mozilla.org/browser/search/telemetry.html#browser- search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.unknown.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> unknown(772);

  /**
   * generated from browser.search.withads.urlbar
   * Records counts of SERP pages with adverts displayed where the search was started from the urlbar. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.urlbar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar(773);

  /**
   * generated from browser.search.withads.urlbar_handoff
   * The count URI loads triggered in a subsession from the urlbar via handoff, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.urlbar_handoff.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar_handoff(774);

  /**
   * generated from browser.search.withads.urlbar_persisted
   * Records counts of SERP pages with adverts displayed where the search was started from the urlbar after the search term was shown in the urlbar. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.urlbar_persisted.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar_persisted(775);

  /**
   * generated from browser.search.withads.urlbar_searchmode
   * Records counts of SERP pages with adverts displayed where the search was started from the urlbar in search mode. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.urlbar_searchmode.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> urlbar_searchmode(776);

  /**
   * generated from browser.search.withads.webextension
   * Records counts of SERP pages with adverts displayed where the search was started from a webextension. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source- docs.mozilla.org/browser/search/telemetry.html#browser-search- content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.webextension.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> webextension(777);
}

namespace newtab_search_ad {
  /**
   * generated from newtab.search.ad.click
   */
  struct ClickExtra {
    mozilla::Maybe<bool> isFollowOn;
    mozilla::Maybe<bool> isTagged;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> searchAccessPoint;
    mozilla::Maybe<nsCString> telemetryId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (isFollowOn) {
        extraKeys.AppendElement()->AssignASCII("is_follow_on");
        extraValues.AppendElement()->AssignASCII(isFollowOn.value() ? "true" : "false");
      }
      if (isTagged) {
        extraKeys.AppendElement()->AssignASCII("is_tagged");
        extraValues.AppendElement()->AssignASCII(isTagged.value() ? "true" : "false");
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (searchAccessPoint) {
        extraKeys.AppendElement()->AssignASCII("search_access_point");
        extraValues.EmplaceBack(searchAccessPoint.value());
      }
      if (telemetryId) {
        extraKeys.AppendElement()->AssignASCII("telemetry_id");
        extraValues.EmplaceBack(telemetryId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when an ad link is clicked on a Search Engine Result Page (SERP) which was loaded by a seach that began on a newtab page.
   */
  constexpr impl::EventMetric<ClickExtra> click(778);

  /**
   * generated from newtab.search.ad.impression
   */
  struct ImpressionExtra {
    mozilla::Maybe<bool> isFollowOn;
    mozilla::Maybe<bool> isTagged;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> searchAccessPoint;
    mozilla::Maybe<nsCString> telemetryId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (isFollowOn) {
        extraKeys.AppendElement()->AssignASCII("is_follow_on");
        extraValues.AppendElement()->AssignASCII(isFollowOn.value() ? "true" : "false");
      }
      if (isTagged) {
        extraKeys.AppendElement()->AssignASCII("is_tagged");
        extraValues.AppendElement()->AssignASCII(isTagged.value() ? "true" : "false");
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (searchAccessPoint) {
        extraKeys.AppendElement()->AssignASCII("search_access_point");
        extraValues.EmplaceBack(searchAccessPoint.value());
      }
      if (telemetryId) {
        extraKeys.AppendElement()->AssignASCII("telemetry_id");
        extraValues.EmplaceBack(telemetryId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a newtab visit resulted in a search that loaded a Search Engine Result Page (SERP) that contains an ad link. And the SERP is visible.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(779);
}

namespace sap {
  /**
   * generated from sap.counts
   */
  struct CountsExtra {
    mozilla::Maybe<bool> overriddenByThirdParty;
    mozilla::Maybe<nsCString> partnerCode;
    mozilla::Maybe<nsCString> providerId;
    mozilla::Maybe<nsCString> providerName;
    mozilla::Maybe<nsCString> source;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (overriddenByThirdParty) {
        extraKeys.AppendElement()->AssignASCII("overridden_by_third_party");
        extraValues.AppendElement()->AssignASCII(overriddenByThirdParty.value() ? "true" : "false");
      }
      if (partnerCode) {
        extraKeys.AppendElement()->AssignASCII("partner_code");
        extraValues.EmplaceBack(partnerCode.value());
      }
      if (providerId) {
        extraKeys.AppendElement()->AssignASCII("provider_id");
        extraValues.EmplaceBack(providerId.value());
      }
      if (providerName) {
        extraKeys.AppendElement()->AssignASCII("provider_name");
        extraValues.EmplaceBack(providerName.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded search counts when a user initiates a search from a search access point (SAP). It does not guarantee that the search engine result page was loaded successfully (use SERP telemetry).
   */
  constexpr impl::EventMetric<CountsExtra> counts(780);

  /**
   * generated from sap.deprecated_counts
   * This is deprecated metric that should not be incoporated into dashboards. Use the `sap.counts` event instead.
   * This metric has been added to Glean to aid transition of histograms and allow the legacy telemetry SEARCH_COUNTS to continue to be recorded.
   * Records search counts for search access points. The format is: <engine-name>.<search-access-point>. For the urlbar when in search mode, the format is <engine name>.urlbar-searchmode. For the urlbar when an internal @engine shortcut is used, the format is: <engine-name>.alias.
   * This metric was generated to correspond to the Legacy Telemetry count histogram SEARCH_COUNTS.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> deprecated_counts(781);

  /**
   * generated from sap.search_form_counts
   */
  struct SearchFormCountsExtra {
    mozilla::Maybe<nsCString> providerId;
    mozilla::Maybe<nsCString> source;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (providerId) {
        extraKeys.AppendElement()->AssignASCII("provider_id");
        extraValues.EmplaceBack(providerId.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records how often users visit the homepages of search engines (also known as SearchForm) using a SAP. It only counts how many visits were initiated, not how many homepages were loaded successfully.
   */
  constexpr impl::EventMetric<SearchFormCountsExtra> search_form_counts(782);
}

namespace search_with {
  /**
   * generated from search_with.context_id
   * An identifier for Contextual Services user interaction pings. This is used internally for counting unique users as well as for anti-fraud. It is shared with other Contextual Services. It is not shared externally.
   */
  constexpr impl::UuidMetric context_id(783);

  /**
   * generated from search_with.reporting_url
   * The external url to report this interaction to.
   */
  constexpr impl::UrlMetric reporting_url(784);
}

namespace searchbar {
  /**
   * generated from searchbar.selected_result_method
   */
  enum class SelectedResultMethodLabel: uint16_t {
    eEnter = 0,
    eEnterselection = 1,
    eClick = 2,
    e__Other__,
  };
  /**
   * The input method the user used to select a result in the searchbar. 'enter' => The user hit the Enter key without choosing a result in the popup. 'enterSelection' => The user chose a result and then hit the Enter key. 'click' => The user clicked a result with the mouse.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram FX_SEARCHBAR_SELECTED_RESULT_METHOD.
   */
  constexpr impl::Labeled<impl::CounterMetric, SelectedResultMethodLabel> selected_result_method(785);
}

namespace serp {
  /**
   * generated from serp.abandonment
   */
  struct AbandonmentExtra {
    mozilla::Maybe<nsCString> impressionId;
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (impressionId) {
        extraKeys.AppendElement()->AssignASCII("impression_id");
        extraValues.EmplaceBack(impressionId.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when there is no engagement with the SERP before the tab is closed, the window is closed, the app is closed, or the tab is navigated away from.
   */
  constexpr impl::EventMetric<AbandonmentExtra> abandonment(786);

  /**
   * generated from serp.ad_impression
   */
  struct AdImpressionExtra {
    mozilla::Maybe<uint32_t> adsHidden;
    mozilla::Maybe<uint32_t> adsLoaded;
    mozilla::Maybe<uint32_t> adsVisible;
    mozilla::Maybe<nsCString> component;
    mozilla::Maybe<nsCString> impressionId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (adsHidden) {
        extraKeys.AppendElement()->AssignASCII("ads_hidden");
        extraValues.AppendElement()->AppendInt(adsHidden.value());
      }
      if (adsLoaded) {
        extraKeys.AppendElement()->AssignASCII("ads_loaded");
        extraValues.AppendElement()->AppendInt(adsLoaded.value());
      }
      if (adsVisible) {
        extraKeys.AppendElement()->AssignASCII("ads_visible");
        extraValues.AppendElement()->AppendInt(adsVisible.value());
      }
      if (component) {
        extraKeys.AppendElement()->AssignASCII("component");
        extraValues.EmplaceBack(component.value());
      }
      if (impressionId) {
        extraKeys.AppendElement()->AssignASCII("impression_id");
        extraValues.EmplaceBack(impressionId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user loads a SERP and ads are detected.
   */
  constexpr impl::EventMetric<AdImpressionExtra> ad_impression(787);

  /**
   * generated from serp.ads_blocked_count
   */
  enum class AdsBlockedCountLabel: uint16_t {
    eBeyondViewport = 0,
    eHiddenParent = 1,
    eHiddenChild = 2,
    e__Other__,
  };
  /**
   * Counts the specific type of block.
   */
  constexpr impl::Labeled<impl::CounterMetric, AdsBlockedCountLabel> ads_blocked_count(788);

  /**
   * generated from serp.categorization
   */
  struct CategorizationExtra {
    mozilla::Maybe<uint32_t> appVersion;
    mozilla::Maybe<nsCString> channel;
    mozilla::Maybe<bool> isShoppingPage;
    mozilla::Maybe<uint32_t> mappingsVersion;
    mozilla::Maybe<uint32_t> numAdsClicked;
    mozilla::Maybe<uint32_t> numAdsHidden;
    mozilla::Maybe<uint32_t> numAdsLoaded;
    mozilla::Maybe<uint32_t> numAdsVisible;
    mozilla::Maybe<uint32_t> organicCategory;
    mozilla::Maybe<uint32_t> organicNumDomains;
    mozilla::Maybe<uint32_t> organicNumInconclusive;
    mozilla::Maybe<uint32_t> organicNumUnknown;
    mozilla::Maybe<nsCString> partnerCode;
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<nsCString> region;
    mozilla::Maybe<uint32_t> sponsoredCategory;
    mozilla::Maybe<uint32_t> sponsoredNumDomains;
    mozilla::Maybe<uint32_t> sponsoredNumInconclusive;
    mozilla::Maybe<uint32_t> sponsoredNumUnknown;
    mozilla::Maybe<bool> tagged;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (appVersion) {
        extraKeys.AppendElement()->AssignASCII("app_version");
        extraValues.AppendElement()->AppendInt(appVersion.value());
      }
      if (channel) {
        extraKeys.AppendElement()->AssignASCII("channel");
        extraValues.EmplaceBack(channel.value());
      }
      if (isShoppingPage) {
        extraKeys.AppendElement()->AssignASCII("is_shopping_page");
        extraValues.AppendElement()->AssignASCII(isShoppingPage.value() ? "true" : "false");
      }
      if (mappingsVersion) {
        extraKeys.AppendElement()->AssignASCII("mappings_version");
        extraValues.AppendElement()->AppendInt(mappingsVersion.value());
      }
      if (numAdsClicked) {
        extraKeys.AppendElement()->AssignASCII("num_ads_clicked");
        extraValues.AppendElement()->AppendInt(numAdsClicked.value());
      }
      if (numAdsHidden) {
        extraKeys.AppendElement()->AssignASCII("num_ads_hidden");
        extraValues.AppendElement()->AppendInt(numAdsHidden.value());
      }
      if (numAdsLoaded) {
        extraKeys.AppendElement()->AssignASCII("num_ads_loaded");
        extraValues.AppendElement()->AppendInt(numAdsLoaded.value());
      }
      if (numAdsVisible) {
        extraKeys.AppendElement()->AssignASCII("num_ads_visible");
        extraValues.AppendElement()->AppendInt(numAdsVisible.value());
      }
      if (organicCategory) {
        extraKeys.AppendElement()->AssignASCII("organic_category");
        extraValues.AppendElement()->AppendInt(organicCategory.value());
      }
      if (organicNumDomains) {
        extraKeys.AppendElement()->AssignASCII("organic_num_domains");
        extraValues.AppendElement()->AppendInt(organicNumDomains.value());
      }
      if (organicNumInconclusive) {
        extraKeys.AppendElement()->AssignASCII("organic_num_inconclusive");
        extraValues.AppendElement()->AppendInt(organicNumInconclusive.value());
      }
      if (organicNumUnknown) {
        extraKeys.AppendElement()->AssignASCII("organic_num_unknown");
        extraValues.AppendElement()->AppendInt(organicNumUnknown.value());
      }
      if (partnerCode) {
        extraKeys.AppendElement()->AssignASCII("partner_code");
        extraValues.EmplaceBack(partnerCode.value());
      }
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (region) {
        extraKeys.AppendElement()->AssignASCII("region");
        extraValues.EmplaceBack(region.value());
      }
      if (sponsoredCategory) {
        extraKeys.AppendElement()->AssignASCII("sponsored_category");
        extraValues.AppendElement()->AppendInt(sponsoredCategory.value());
      }
      if (sponsoredNumDomains) {
        extraKeys.AppendElement()->AssignASCII("sponsored_num_domains");
        extraValues.AppendElement()->AppendInt(sponsoredNumDomains.value());
      }
      if (sponsoredNumInconclusive) {
        extraKeys.AppendElement()->AssignASCII("sponsored_num_inconclusive");
        extraValues.AppendElement()->AppendInt(sponsoredNumInconclusive.value());
      }
      if (sponsoredNumUnknown) {
        extraKeys.AppendElement()->AssignASCII("sponsored_num_unknown");
        extraValues.AppendElement()->AppendInt(sponsoredNumUnknown.value());
      }
      if (tagged) {
        extraKeys.AppendElement()->AssignASCII("tagged");
        extraValues.AppendElement()->AssignASCII(tagged.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A high-level categorization of a SERP (a best guess as to its topic), using buckets such as "sports" or "travel".
   */
  constexpr impl::EventMetric<CategorizationExtra> categorization(789);

  /**
   * generated from serp.categorization_duration
   * The time it takes to categorize elements on a SERP.
   */
  constexpr impl::TimingDistributionMetric categorization_duration(790);

  /**
   * generated from serp.categorization_no_map_found
   * A count incremented upon a SERP categorization event being recorded without a corresponding impression event being recorded. This metric effectively counts missing impressions due to issues with the domain-to-categories map.
   */
  constexpr impl::CounterMetric categorization_no_map_found(791);

  /**
   * generated from serp.engagement
   */
  struct EngagementExtra {
    mozilla::Maybe<nsCString> action;
    mozilla::Maybe<nsCString> impressionId;
    mozilla::Maybe<nsCString> target;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (action) {
        extraKeys.AppendElement()->AssignASCII("action");
        extraValues.EmplaceBack(action.value());
      }
      if (impressionId) {
        extraKeys.AppendElement()->AssignASCII("impression_id");
        extraValues.EmplaceBack(impressionId.value());
      }
      if (target) {
        extraKeys.AppendElement()->AssignASCII("target");
        extraValues.EmplaceBack(target.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded user actions on a SERP.
   */
  constexpr impl::EventMetric<EngagementExtra> engagement(792);


  /**
   * generated from serp.impression
   */
  struct ImpressionExtra {
    mozilla::Maybe<nsCString> impressionId;
    mozilla::Maybe<bool> isPrivate;
    mozilla::Maybe<bool> isShoppingPage;
    mozilla::Maybe<bool> isSignedIn;
    mozilla::Maybe<nsCString> partnerCode;
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<bool> shoppingTabDisplayed;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<bool> tagged;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (impressionId) {
        extraKeys.AppendElement()->AssignASCII("impression_id");
        extraValues.EmplaceBack(impressionId.value());
      }
      if (isPrivate) {
        extraKeys.AppendElement()->AssignASCII("is_private");
        extraValues.AppendElement()->AssignASCII(isPrivate.value() ? "true" : "false");
      }
      if (isShoppingPage) {
        extraKeys.AppendElement()->AssignASCII("is_shopping_page");
        extraValues.AppendElement()->AssignASCII(isShoppingPage.value() ? "true" : "false");
      }
      if (isSignedIn) {
        extraKeys.AppendElement()->AssignASCII("is_signed_in");
        extraValues.AppendElement()->AssignASCII(isSignedIn.value() ? "true" : "false");
      }
      if (partnerCode) {
        extraKeys.AppendElement()->AssignASCII("partner_code");
        extraValues.EmplaceBack(partnerCode.value());
      }
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (shoppingTabDisplayed) {
        extraKeys.AppendElement()->AssignASCII("shopping_tab_displayed");
        extraValues.AppendElement()->AssignASCII(shoppingTabDisplayed.value() ? "true" : "false");
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (tagged) {
        extraKeys.AppendElement()->AssignASCII("tagged");
        extraValues.AppendElement()->AssignASCII(tagged.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a search engine results page (SERP) is shown to a user. The feature began rolling out to all users with Firefox 115, and was permanently enabled in Firefox 119.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(794);
}

namespace urlbar_searchmode {
  /**
   * generated from urlbar.searchmode.bookmarkmenu
   * A keyed uint recording how many times the user entered a particular search mode after selecing the Search Bookmarks menu item in the Library menu. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.bookmarkmenu.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> bookmarkmenu(795);

  /**
   * generated from urlbar.searchmode.handoff
   * A keyed uint recording how many times the user entered a particular search mode after being handed off from the search bar on the new tab page. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.handoff.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> handoff(796);

  /**
   * generated from urlbar.searchmode.historymenu
   * A keyed uint recording how many times the user entered a particular search mode after selecing the Search History menu item in a History menu. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.historymenu.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> historymenu(797);

  /**
   * generated from urlbar.searchmode.keywordoffer
   * A keyed uint recording how many times the user entered a particular search mode after selecting a keyword offer result. The scalar key for local search modes entered using a restrict keyword will be suffixed with "keyword". For example: tabs_keyword, bookmarks_keyword, history_keyword, and actions_keyword. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.keywordoffer.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> keywordoffer(798);

  /**
   * generated from urlbar.searchmode.oneoff
   * A keyed uint recording how many times the user entered a particular search mode after selecting a one-off. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.oneoff.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> oneoff(799);

  /**
   * generated from urlbar.searchmode.other
   * A keyed uint recording how many times the user entered a particular search mode from an unknown entry point. If values appear for this probe in Telemetry, we should review the entry points to search mode. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.other.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> other(800);

  /**
   * generated from urlbar.searchmode.searchbutton
   * A keyed uint recording how many times the user entered a particular search mode by unified search button. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.searchbutton.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> searchbutton(801);

  /**
   * generated from urlbar.searchmode.shortcut
   * A keyed uint recording how many times the user entered a particular search mode after pressing a keyboard shortcut. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.shortcut.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> shortcut(802);

  /**
   * generated from urlbar.searchmode.tabmenu
   * A keyed uint recording how many times the user entered a particular search mode after selecting the Search Tabs menu item in the Tab Overflow menu. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.tabmenu.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> tabmenu(803);

  /**
   * generated from urlbar.searchmode.tabtosearch
   * A keyed uint recording how many times the user entered a particular search mode after selecting a tab-to-search result. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.tabtosearch.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> tabtosearch(804);

  /**
   * generated from urlbar.searchmode.tabtosearch_onboard
   * A keyed uint recording how many times the user entered a particular search mode after selecting a tab-to-search onboarding result. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.tabtosearch_onboard.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> tabtosearch_onboard(805);

  /**
   * generated from urlbar.searchmode.topsites_newtab
   * A keyed uint recording how many times the user entered a particular search mode after selecting a search shortcut Top Site on the New Tab Page. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.topsites_newtab.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> topsites_newtab(806);

  /**
   * generated from urlbar.searchmode.topsites_urlbar
   * A keyed uint recording how many times the user entered a particular search mode after selecting a search shortcut Top Site in the Urlbar. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.topsites_urlbar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> topsites_urlbar(807);

  /**
   * generated from urlbar.searchmode.touchbar
   * A keyed uint recording how many times the user entered a particular search mode after selecting a search shortcut on the macOS Touch Bar. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.touchbar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> touchbar(808);

  /**
   * generated from urlbar.searchmode.typed
   * A keyed uint recording how many times the user entered a particular search mode after typing an alias. The scalar keys for local search modes entered by typing a restrict keyword will be suffixed with "keyword". For example: tabs_keyword, bookmarks_keyword, history_keyword, and actions_keyword. If instead search mode was entered by typing a restrict symbol the key will be suffixed with "symbol" (e.g. typing "%" will generate "tabs_symbol"). This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.typed.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> typed(809);
}

namespace browser_searchinit {
  /**
   * generated from browser.searchinit.engine_invalid_webextension
   * Records the WebExtension ID of a search engine where the WebExtension is not installed (= 1), disabled (= 2), search engine no longer specified (= 4), a different name (= 5), where the submission URL is different between the search engine and the WebExtension (= 6). The value '3' has been replaced by '6' to distinguish newer entries. This metric was generated to correspond to the Legacy Telemetry scalar browser.searchinit.engine_invalid_webextension, which was removed in Fx 139.
   */
  constexpr impl::Labeled<impl::QuantityMetric, DynamicLabel> engine_invalid_webextension(5515);

  /**
   * generated from browser.searchinit.insecure_opensearch_engine_count
   * Records the number of insecure (i.e., using http) OpenSearch search engines a given user has installed. This metric was generated to correspond to the Legacy Telemetry scalar browser.searchinit.insecure_opensearch_engine_count.
   */
  constexpr impl::QuantityMetric insecure_opensearch_engine_count(5516);

  /**
   * generated from browser.searchinit.insecure_opensearch_update_count
   * Records the number of OpenSearch search engines with insecure updates enabled (i.e., using http) a given user has installed. This metric was generated to correspond to the Legacy Telemetry scalar browser.searchinit.insecure_opensearch_update_count.
   */
  constexpr impl::QuantityMetric insecure_opensearch_update_count(5517);

  /**
   * generated from browser.searchinit.secure_opensearch_engine_count
   * Records the number of secure (i.e., using https) OpenSearch search engines a given user has installed. This metric was generated to correspond to the Legacy Telemetry scalar browser.searchinit.secure_opensearch_engine_count.
   */
  constexpr impl::QuantityMetric secure_opensearch_engine_count(5518);

  /**
   * generated from browser.searchinit.secure_opensearch_update_count
   * Records the number of OpenSearch search engines with secure updates enabled (i.e., using https) a given user has installed. This metric was generated to correspond to the Legacy Telemetry scalar browser.searchinit.secure_opensearch_update_count.
   */
  constexpr impl::QuantityMetric secure_opensearch_update_count(5519);
}

namespace search {
  /**
   * generated from search.suggestions_latency
   * Records the latencies (ms) of search suggestions fetches per search engine. Keys in this histogram are search engine identifiers for built-in search engines and 'other' for non-built-in search engines.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SEARCH_SUGGESTIONS_LATENCY_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> suggestions_latency(5520);
}

namespace search_engine_default {
  /**
   * generated from search.engine.default.changed
   */
  struct ChangedExtra {
    mozilla::Maybe<nsCString> changeReason;
    mozilla::Maybe<nsCString> newDisplayName;
    mozilla::Maybe<nsCString> newEngineId;
    mozilla::Maybe<nsCString> newLoadPath;
    mozilla::Maybe<nsCString> newSubmissionUrl;
    mozilla::Maybe<nsCString> previousEngineId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (changeReason) {
        extraKeys.AppendElement()->AssignASCII("change_reason");
        extraValues.EmplaceBack(changeReason.value());
      }
      if (newDisplayName) {
        extraKeys.AppendElement()->AssignASCII("new_display_name");
        extraValues.EmplaceBack(newDisplayName.value());
      }
      if (newEngineId) {
        extraKeys.AppendElement()->AssignASCII("new_engine_id");
        extraValues.EmplaceBack(newEngineId.value());
      }
      if (newLoadPath) {
        extraKeys.AppendElement()->AssignASCII("new_load_path");
        extraValues.EmplaceBack(newLoadPath.value());
      }
      if (newSubmissionUrl) {
        extraKeys.AppendElement()->AssignASCII("new_submission_url");
        extraValues.EmplaceBack(newSubmissionUrl.value());
      }
      if (previousEngineId) {
        extraKeys.AppendElement()->AssignASCII("previous_engine_id");
        extraValues.EmplaceBack(previousEngineId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the default search engine is changed.
   */
  constexpr impl::EventMetric<ChangedExtra> changed(5521);

  /**
   * generated from search.engine.default.display_name
   * The display name of the user's default engine.
   */
  constexpr impl::StringMetric display_name(5522);

  /**
   * generated from search.engine.default.engine_id
   * Deprecated in Fx139, please use provider_id, partner_code,
   * overridden_by_third_party and display_name instead.
   * 
   * The telemetry id of the search engine.
   * For example: "engine1"
   * 
   * For application-provided engines, this is the identifier plus telemetry
   * suffix supplied by the configuration.
   * For other engines, this is `other-<engineName>`.
   */
  constexpr impl::StringMetric engine_id(5523);

  /**
   * generated from search.engine.default.load_path
   * A path relating to where the search engine was installed/loaded from.
   * For example:
   *   `[app]appDefault` for an app-provided engine.
   *   `[addon]<extension id>` for a WebExtension-based engine.
   *   `[https]developer.mozilla.org/mdn-web-docs.xml` for an OpenSearch-based
   *   engine.
   *   `[policy]` for an enteprise policy engine.
   *   `[user]` for a search engine defined by the user or generated from a
   *   web page.
   * Note: this metric is truncated at 100 characters.
   */
  constexpr impl::StringMetric load_path(5524);

  /**
   * generated from search.engine.default.overridden_by_third_party
   * Set to true if the user's default search engine has been allowed to be
   * overridden by a third-party add-on or OpenSearch engine.
   */
  constexpr impl::BooleanMetric overridden_by_third_party(5525);

  /**
   * generated from search.engine.default.partner_code
   * The partner code of the user's default search engine, if defined/known,
   * that is being used for the search. Not all search engines have partner
   * codes.
   * 
   * May be empty for engines that are overridden by a third-party add-on or
   * OpenSearch engine.
   */
  constexpr impl::StringMetric partner_code(5526);

  /**
   * generated from search.engine.default.provider_id
   * The identifier of the user's default search engine if the search engine is
   * an application provided engine. For user installed engines, this value will
   * be `other`.
   */
  constexpr impl::StringMetric provider_id(5527);

  /**
   * generated from search.engine.default.submission_url
   * The submission URL of the default engine. This is only reported in the
   * cases where:
   *   The engine is an application provided engine.
   *   The engine has the same name as an application provided engine.
   *   The engine matches one of a specific list of well known search engines.
   */
  constexpr impl::UrlMetric submission_url(5528);
}

namespace search_engine_private {
  /**
   * generated from search.engine.private.changed
   */
  struct ChangedExtra {
    mozilla::Maybe<nsCString> changeReason;
    mozilla::Maybe<nsCString> newDisplayName;
    mozilla::Maybe<nsCString> newEngineId;
    mozilla::Maybe<nsCString> newLoadPath;
    mozilla::Maybe<nsCString> newSubmissionUrl;
    mozilla::Maybe<nsCString> previousEngineId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (changeReason) {
        extraKeys.AppendElement()->AssignASCII("change_reason");
        extraValues.EmplaceBack(changeReason.value());
      }
      if (newDisplayName) {
        extraKeys.AppendElement()->AssignASCII("new_display_name");
        extraValues.EmplaceBack(newDisplayName.value());
      }
      if (newEngineId) {
        extraKeys.AppendElement()->AssignASCII("new_engine_id");
        extraValues.EmplaceBack(newEngineId.value());
      }
      if (newLoadPath) {
        extraKeys.AppendElement()->AssignASCII("new_load_path");
        extraValues.EmplaceBack(newLoadPath.value());
      }
      if (newSubmissionUrl) {
        extraKeys.AppendElement()->AssignASCII("new_submission_url");
        extraValues.EmplaceBack(newSubmissionUrl.value());
      }
      if (previousEngineId) {
        extraKeys.AppendElement()->AssignASCII("previous_engine_id");
        extraValues.EmplaceBack(previousEngineId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the default search engine is changed
   */
  constexpr impl::EventMetric<ChangedExtra> changed(5529);

  /**
   * generated from search.engine.private.display_name
   * The display name of the user's default engine.
   * 
   * If this string is an empty string (`""`), this means that one or both of
   * the preferences `browser.search.separatePrivateDefault` and
   * `browser.search.separatePrivateDefault.ui.enabled` are set to false.
   * It is possible that the user selects the same private engine as for the
   * default engine, and hence both versions of these fields will be filled in.
   */
  constexpr impl::StringMetric display_name(5530);

  /**
   * generated from search.engine.private.engine_id
   * Deprecated in Fx139, please use provider_id, partner_code,
   * overridden_by_third_party and display_name instead.
   * 
   * The telemetry id of the search engine.
   * For example: "engine1"
   * 
   * For application-provided engines, this is the identifier plus telemetry
   * suffix supplied by the configuration.
   * For other engines, this is `other-<engineName>`.
   * 
   * If this string is an empty string (`""`), this means that one or both of
   * the preferences `browser.search.separatePrivateDefault` and
   * `browser.search.separatePrivateDefault.ui.enabled` are set to false.
   * It is possible that the user selects the same private engine as for the
   * default engine, and hence both versions of these fields will be filled in.
   */
  constexpr impl::StringMetric engine_id(5531);

  /**
   * generated from search.engine.private.load_path
   * A path relating to where the search engine was installed/loaded from.
   * For example:
   *   `[app]appDefault` for an app-provided engine.
   *   `[addon]<extension id>` for a WebExtension-based engine.
   *   `[https]developer.mozilla.org/mdn-web-docs.xml` for an OpenSearch-based
   *   engine.
   *   `[policy]` for an enteprise policy engine.
   *   `[user]` for a search engine defined by the user or generated from a
   *   web page.
   * Note: this metric is truncated at 100 characters.
   * 
   * If this string is an empty string (`""`), this means that one or both of
   * the preferences `browser.search.separatePrivateDefault` and
   * `browser.search.separatePrivateDefault.ui.enabled` are set to false.
   * It is possible that the user selects the same private engine as for the
   * default engine, and hence both versions of these fields will be filled in.
   */
  constexpr impl::StringMetric load_path(5532);

  /**
   * generated from search.engine.private.overridden_by_third_party
   * Set to true if the user's default search engine has been allowed to be
   * overridden by a third-party add-on or OpenSearch engine.
   */
  constexpr impl::BooleanMetric overridden_by_third_party(5533);

  /**
   * generated from search.engine.private.partner_code
   * The partner code of the user's default search engine, if defined/known,
   * that is being used for the search. Not all search engines have partner
   * codes.
   * 
   * May be empty for engines that are overridden by a third-party add-on or
   * OpenSearch engine.
   */
  constexpr impl::StringMetric partner_code(5534);

  /**
   * generated from search.engine.private.provider_id
   * The identifier of the user's default search engine if the search engine is
   * an application provided engine. For user installed engines, this value will
   * be `other`.
   */
  constexpr impl::StringMetric provider_id(5535);

  /**
   * generated from search.engine.private.submission_url
   * The submission URL of the default engine. This is only reported in the
   * cases where:
   *   The engine is an application provided engine.
   *   The engine has the same name as an application provided engine.
   *   The engine matches one of a specific list of well known search engines.
   * If this string is an empty string (`""`), this means that one or both of
   * the preferences `browser.search.separatePrivateDefault` and
   * `browser.search.separatePrivateDefault.ui.enabled` are set to false.
   * It is possible that the user selects the same private engine as for the
   * default engine, and hence both versions of these fields will be filled in.
   */
  constexpr impl::UrlMetric submission_url(5536);
}

namespace search_service {
  /**
   * generated from search.service.initialization_status
   */
  enum class InitializationStatusLabel: uint16_t {
    eFailedsettings = 0,
    eFailedfetchengines = 1,
    eFailedloadengines = 2,
    eFailedloadsettingsaddonmanager = 3,
    eSettingscorrupt = 4,
    eSuccess = 5,
    e__Other__,
  };
  /**
   * Counts the type of initialization statuses on start up.
   * failedSettings - failed loading and migrating the search settings file.
   * failedFetchEngines - failed to load or parse the configuration from remote
   *                      settings.
   * failedLoadEngines - failed to create all the search engines from the
   *                     configuration or user installed engines.
   * failedLoadSettingsAddonManager - the addon manager ready promise was rejected. (from FF135)
   * settingsCorrupt - the search settings were reset because of an exception, but
   *                   the search service still finished initializing. (from FF136)
   * success - search service successfully initialized.
   */
  constexpr impl::Labeled<impl::CounterMetric, InitializationStatusLabel> initialization_status(5537);

  /**
   * generated from search.service.startup_time
   * The time duration it takes for the search service to start up.
   */
  constexpr impl::TimingDistributionMetric startup_time(5538);
}

namespace search_suggestions {
  /**
   * generated from search.suggestions.aborted_requests
   * Counts the number of aborted search suggestion fetches per search engine. Only records app provided engines using their short IDs ('id', not 'identifier') as labels.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> aborted_requests(5539);

  /**
   * generated from search.suggestions.failed_requests
   * Counts the number of failed search suggestion fetches per search engine. Only records app provided engines using their short IDs ('id', not 'identifier') as labels.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> failed_requests(5540);

  /**
   * generated from search.suggestions.successful_requests
   * Counts the number of successful search suggestion fetches per search engine. Only records app provided engines using their short IDs ('id', not 'identifier') as labels.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> successful_requests(5541);
}

} // namespace mozilla::glean

#endif // mozilla_GleanSearchMetrics_h
