/* THIS FILE IS AUTOGENERATED FROM InspectorUtils.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_InspectorUtilsBinding_h
#define mozilla_dom_InspectorUtilsBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

class InspectorFontFace;
struct InspectorFontFeatureAtoms;
struct InspectorRGBATupleAtoms;
class InspectorUtils;
struct InspectorVariationAxisAtoms;
struct InspectorVariationInstanceAtoms;
struct InspectorVariationValue;
struct InspectorVariationValueAtoms;
struct NativePropertyHooks;
struct PropertyNamesOptionsAtoms;
struct PropertyPrefAtoms;
class ProtoAndIfaceCache;
struct SupportsOptionsAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class InspectorPropertyType : uint8_t {
  Color,
  Gradient,
  Timing_function,
  EndGuard_
};

namespace InspectorPropertyTypeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(InspectorPropertyType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(InspectorPropertyType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace InspectorPropertyTypeValues

bool
ToJSValue(JSContext* aCx, InspectorPropertyType aArgument, JS::MutableHandle<JS::Value> aValue);


struct InspectorFontFeature : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mLanguageSystem;
  MOZ_INIT_OUTSIDE_CTOR nsString mScript;
  MOZ_INIT_OUTSIDE_CTOR nsString mTag;

  InspectorFontFeature();

  explicit inline InspectorFontFeature(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  InspectorFontFeature(InspectorFontFeature&& aOther) = default;

  explicit inline InspectorFontFeature(const InspectorFontFeature& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  InspectorFontFeature&
  operator=(const InspectorFontFeature& aOther);

  bool
  operator==(const InspectorFontFeature& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, InspectorFontFeatureAtoms* atomsCache);
};

namespace binding_detail {
struct FastInspectorFontFeature : public InspectorFontFeature
{
  inline FastInspectorFontFeature()
    : InspectorFontFeature(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct InspectorRGBATuple : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR double mA;
  MOZ_INIT_OUTSIDE_CTOR double mB;
  MOZ_INIT_OUTSIDE_CTOR double mG;
  MOZ_INIT_OUTSIDE_CTOR double mR;

  InspectorRGBATuple();

  explicit inline InspectorRGBATuple(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  InspectorRGBATuple(InspectorRGBATuple&& aOther) = default;

  explicit inline InspectorRGBATuple(const InspectorRGBATuple& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  InspectorRGBATuple&
  operator=(const InspectorRGBATuple& aOther);

  bool
  operator==(const InspectorRGBATuple& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, InspectorRGBATupleAtoms* atomsCache);
};

namespace binding_detail {
struct FastInspectorRGBATuple : public InspectorRGBATuple
{
  inline FastInspectorRGBATuple()
    : InspectorRGBATuple(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct InspectorVariationAxis : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR float mDefaultValue;
  MOZ_INIT_OUTSIDE_CTOR float mMaxValue;
  MOZ_INIT_OUTSIDE_CTOR float mMinValue;
  MOZ_INIT_OUTSIDE_CTOR nsString mName;
  MOZ_INIT_OUTSIDE_CTOR nsString mTag;

  InspectorVariationAxis();

  explicit inline InspectorVariationAxis(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  InspectorVariationAxis(InspectorVariationAxis&& aOther) = default;

  explicit inline InspectorVariationAxis(const InspectorVariationAxis& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  InspectorVariationAxis&
  operator=(const InspectorVariationAxis& aOther);

  bool
  operator==(const InspectorVariationAxis& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, InspectorVariationAxisAtoms* atomsCache);
};

namespace binding_detail {
struct FastInspectorVariationAxis : public InspectorVariationAxis
{
  inline FastInspectorVariationAxis()
    : InspectorVariationAxis(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct InspectorVariationValue : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mAxis;
  MOZ_INIT_OUTSIDE_CTOR float mValue;

  InspectorVariationValue();

  explicit inline InspectorVariationValue(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  InspectorVariationValue(InspectorVariationValue&& aOther) = default;

  explicit inline InspectorVariationValue(const InspectorVariationValue& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  InspectorVariationValue&
  operator=(const InspectorVariationValue& aOther);

  bool
  operator==(const InspectorVariationValue& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, InspectorVariationValueAtoms* atomsCache);
};

namespace binding_detail {
struct FastInspectorVariationValue : public InspectorVariationValue
{
  inline FastInspectorVariationValue()
    : InspectorVariationValue(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PropertyNamesOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mIncludeAliases;
  MOZ_INIT_OUTSIDE_CTOR bool mIncludeExperimentals;
  MOZ_INIT_OUTSIDE_CTOR bool mIncludeShorthands;

  PropertyNamesOptions();

  explicit inline PropertyNamesOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  PropertyNamesOptions(PropertyNamesOptions&& aOther) = default;

  explicit inline PropertyNamesOptions(const PropertyNamesOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  PropertyNamesOptions&
  operator=(const PropertyNamesOptions& aOther);

  bool
  operator==(const PropertyNamesOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, PropertyNamesOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastPropertyNamesOptions : public PropertyNamesOptions
{
  inline FastPropertyNamesOptions()
    : PropertyNamesOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PropertyPref : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mName;
  MOZ_INIT_OUTSIDE_CTOR nsString mPref;

  PropertyPref();

  explicit inline PropertyPref(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  PropertyPref(PropertyPref&& aOther) = default;

  explicit inline PropertyPref(const PropertyPref& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  PropertyPref&
  operator=(const PropertyPref& aOther);

  bool
  operator==(const PropertyPref& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, PropertyPrefAtoms* atomsCache);
};

namespace binding_detail {
struct FastPropertyPref : public PropertyPref
{
  inline FastPropertyPref()
    : PropertyPref(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SupportsOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mChrome;
  MOZ_INIT_OUTSIDE_CTOR bool mQuirks;
  MOZ_INIT_OUTSIDE_CTOR bool mUserAgent;

  SupportsOptions();

  explicit inline SupportsOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SupportsOptions(SupportsOptions&& aOther) = default;

  explicit inline SupportsOptions(const SupportsOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SupportsOptions&
  operator=(const SupportsOptions& aOther);

  bool
  operator==(const SupportsOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, SupportsOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastSupportsOptions : public SupportsOptions
{
  inline FastSupportsOptions()
    : SupportsOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct InspectorVariationInstance : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mName;
  MOZ_INIT_OUTSIDE_CTOR Sequence<InspectorVariationValue> mValues;

  InspectorVariationInstance();

  explicit inline InspectorVariationInstance(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  InspectorVariationInstance(InspectorVariationInstance&& aOther) = default;

  explicit inline InspectorVariationInstance(const InspectorVariationInstance& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  InspectorVariationInstance&
  operator=(const InspectorVariationInstance& aOther);

private:
  static bool
  InitIds(JSContext* cx, InspectorVariationInstanceAtoms* atomsCache);
};

namespace binding_detail {
struct FastInspectorVariationInstance : public InspectorVariationInstance
{
  inline FastInspectorVariationInstance()
    : InspectorVariationInstance(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace InspectorFontFace_Binding {

  typedef mozilla::dom::InspectorFontFace NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::InspectorFontFace* aObject, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::InspectorFontFace,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::InspectorFontFace,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::InspectorFontFace,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace InspectorFontFace_Binding



namespace InspectorUtils_Binding {

  typedef mozilla::dom::InspectorUtils NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::InspectorUtils,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::InspectorUtils,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace InspectorUtils_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_InspectorUtilsBinding_h
