// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanPictureinpictureMetrics_h
#define mozilla_GleanPictureinpictureMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace pictureinpicture {
  /**
   * generated from pictureinpicture.background_tab_playing_duration
   * The length of time (in seconds) that a video was in Picture-in-Picture mode in a background tab.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_PICTURE_IN_PICTURE_BACKGROUND_TAB_PLAYING_DURATION.
   */
  constexpr impl::TimingDistributionMetric background_tab_playing_duration(5182);

  /**
   * generated from pictureinpicture.closed_method_browser_crash
   */
  /**
   * Records the method for closing the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.closed_method#browserCrash.
   */
  constexpr impl::EventMetric<NoExtraKeys> closed_method_browser_crash(5183);

  /**
   * generated from pictureinpicture.closed_method_close_button
   */
  /**
   * Records the method for closing the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.closed_method#closeButton.
   */
  constexpr impl::EventMetric<NoExtraKeys> closed_method_close_button(5184);

  /**
   * generated from pictureinpicture.closed_method_close_player_shortcut
   */
  /**
   * Records the method for closing the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.closed_method#closePlayerShortcut.
   */
  constexpr impl::EventMetric<NoExtraKeys> closed_method_close_player_shortcut(5185);

  /**
   * generated from pictureinpicture.closed_method_context_menu
   */
  /**
   * Records the method for closing the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.closed_method#contextMenu.
   */
  constexpr impl::EventMetric<NoExtraKeys> closed_method_context_menu(5186);

  /**
   * generated from pictureinpicture.closed_method_foregrounded
   */
  /**
   * Records the method for closing the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.closed_method#foregrounded.
   */
  constexpr impl::EventMetric<NoExtraKeys> closed_method_foregrounded(5187);

  /**
   * generated from pictureinpicture.closed_method_fullscreen
   */
  /**
   * Records the method for closing the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.closed_method#fullscreen.
   */
  constexpr impl::EventMetric<NoExtraKeys> closed_method_fullscreen(5188);

  /**
   * generated from pictureinpicture.closed_method_pagehide
   */
  /**
   * Records the method for closing the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.closed_method#pagehide.
   */
  constexpr impl::EventMetric<NoExtraKeys> closed_method_pagehide(5189);

  /**
   * generated from pictureinpicture.closed_method_setup_failure
   */
  /**
   * Records the method for closing the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.closed_method#setupFailure.
   */
  constexpr impl::EventMetric<NoExtraKeys> closed_method_setup_failure(5190);

  /**
   * generated from pictureinpicture.closed_method_shortcut
   */
  /**
   * Records the method for closing the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.closed_method#shortcut.
   */
  constexpr impl::EventMetric<NoExtraKeys> closed_method_shortcut(5191);

  /**
   * generated from pictureinpicture.closed_method_unpip
   */
  /**
   * Records the method for closing the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.closed_method#unpip.
   */
  constexpr impl::EventMetric<NoExtraKeys> closed_method_unpip(5192);

  /**
   * generated from pictureinpicture.closed_method_url_bar
   */
  /**
   * Records the method for closing the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.closed_method#urlBar.
   */
  constexpr impl::EventMetric<NoExtraKeys> closed_method_url_bar(5193);

  /**
   * generated from pictureinpicture.closed_method_video_el_emptied
   */
  /**
   * Records the method for closing the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.closed_method#videoElEmptied.
   */
  constexpr impl::EventMetric<NoExtraKeys> closed_method_video_el_emptied(5194);

  /**
   * generated from pictureinpicture.closed_method_video_el_remove
   */
  /**
   * Records the method for closing the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.closed_method#videoElRemove.
   */
  constexpr impl::EventMetric<NoExtraKeys> closed_method_video_el_remove(5195);

  /**
   * generated from pictureinpicture.create_player
   */
  struct CreatePlayerExtra {
    mozilla::Maybe<bool> ccenabled;
    mozilla::Maybe<uint32_t> height;
    mozilla::Maybe<uint32_t> screenx;
    mozilla::Maybe<uint32_t> screeny;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<bool> webvttsubtitles;
    mozilla::Maybe<uint32_t> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (ccenabled) {
        extraKeys.AppendElement()->AssignASCII("ccEnabled");
        extraValues.AppendElement()->AssignASCII(ccenabled.value() ? "true" : "false");
      }
      if (height) {
        extraKeys.AppendElement()->AssignASCII("height");
        extraValues.AppendElement()->AppendInt(height.value());
      }
      if (screenx) {
        extraKeys.AppendElement()->AssignASCII("screenX");
        extraValues.AppendElement()->AppendInt(screenx.value());
      }
      if (screeny) {
        extraKeys.AppendElement()->AssignASCII("screenY");
        extraValues.AppendElement()->AppendInt(screeny.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (webvttsubtitles) {
        extraKeys.AppendElement()->AssignASCII("webVTTSubtitles");
        extraValues.AppendElement()->AssignASCII(webvttsubtitles.value() ? "true" : "false");
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.AppendElement()->AppendInt(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the Picture-in-Picture player window is created. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.create#player.
   */
  constexpr impl::EventMetric<CreatePlayerExtra> create_player(5196);

  /**
   * generated from pictureinpicture.disrespect_disable_url_bar
   */
  /**
   * Recorded when the user chooses to enable PiP anyway on a PiP disabled video This event was generated to correspond to the Legacy Telemetry event pictureinpicture.disrespect_disable#urlBar.
   */
  constexpr impl::EventMetric<NoExtraKeys> disrespect_disable_url_bar(5197);

  /**
   * generated from pictureinpicture.foreground_tab_playing_duration
   * The length of time (in seconds) that a video was in Picture-in-Picture mode in a foreground tab.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_PICTURE_IN_PICTURE_FOREGROUND_TAB_PLAYING_DURATION.
   */
  constexpr impl::TimingDistributionMetric foreground_tab_playing_duration(5198);

  /**
   * generated from pictureinpicture.fullscreen_player
   */
  struct FullscreenPlayerExtra {
    mozilla::Maybe<bool> enter;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (enter) {
        extraKeys.AppendElement()->AssignASCII("enter");
        extraValues.AppendElement()->AssignASCII(enter.value() ? "true" : "false");
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user clicks the fullscreen button This event was generated to correspond to the Legacy Telemetry event pictureinpicture.fullscreen#player.
   */
  constexpr impl::EventMetric<FullscreenPlayerExtra> fullscreen_player(5199);

  /**
   * generated from pictureinpicture.most_concurrent_players
   * The most concurrent Picture-in-Picture players the user had open at any one time. This metric was generated to correspond to the Legacy Telemetry scalar pictureinpicture.most_concurrent_players.
   */
  constexpr impl::QuantityMetric most_concurrent_players(5200);

  /**
   * generated from pictureinpicture.opened_method_auto_pip
   */
  struct OpenedMethodAutoPipExtra {
    mozilla::Maybe<bool> callout;
    mozilla::Maybe<bool> disabledialog;
    mozilla::Maybe<bool> firsttimetoggle;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (callout) {
        extraKeys.AppendElement()->AssignASCII("callout");
        extraValues.AppendElement()->AssignASCII(callout.value() ? "true" : "false");
      }
      if (disabledialog) {
        extraKeys.AppendElement()->AssignASCII("disableDialog");
        extraValues.AppendElement()->AssignASCII(disabledialog.value() ? "true" : "false");
      }
      if (firsttimetoggle) {
        extraKeys.AppendElement()->AssignASCII("firstTimeToggle");
        extraValues.AppendElement()->AssignASCII(firsttimetoggle.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records the method for opening the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.opened_method#autoPip.
   */
  constexpr impl::EventMetric<OpenedMethodAutoPipExtra> opened_method_auto_pip(5201);

  /**
   * generated from pictureinpicture.opened_method_context_menu
   */
  struct OpenedMethodContextMenuExtra {
    mozilla::Maybe<bool> callout;
    mozilla::Maybe<bool> disabledialog;
    mozilla::Maybe<bool> firsttimetoggle;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (callout) {
        extraKeys.AppendElement()->AssignASCII("callout");
        extraValues.AppendElement()->AssignASCII(callout.value() ? "true" : "false");
      }
      if (disabledialog) {
        extraKeys.AppendElement()->AssignASCII("disableDialog");
        extraValues.AppendElement()->AssignASCII(disabledialog.value() ? "true" : "false");
      }
      if (firsttimetoggle) {
        extraKeys.AppendElement()->AssignASCII("firstTimeToggle");
        extraValues.AppendElement()->AssignASCII(firsttimetoggle.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records the method for opening the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.opened_method#contextMenu.
   */
  constexpr impl::EventMetric<OpenedMethodContextMenuExtra> opened_method_context_menu(5202);

  /**
   * generated from pictureinpicture.opened_method_shortcut
   */
  struct OpenedMethodShortcutExtra {
    mozilla::Maybe<bool> callout;
    mozilla::Maybe<bool> disabledialog;
    mozilla::Maybe<bool> firsttimetoggle;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (callout) {
        extraKeys.AppendElement()->AssignASCII("callout");
        extraValues.AppendElement()->AssignASCII(callout.value() ? "true" : "false");
      }
      if (disabledialog) {
        extraKeys.AppendElement()->AssignASCII("disableDialog");
        extraValues.AppendElement()->AssignASCII(disabledialog.value() ? "true" : "false");
      }
      if (firsttimetoggle) {
        extraKeys.AppendElement()->AssignASCII("firstTimeToggle");
        extraValues.AppendElement()->AssignASCII(firsttimetoggle.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records the method for opening the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.opened_method#shortcut.
   */
  constexpr impl::EventMetric<OpenedMethodShortcutExtra> opened_method_shortcut(5203);

  /**
   * generated from pictureinpicture.opened_method_toggle
   */
  struct OpenedMethodToggleExtra {
    mozilla::Maybe<bool> callout;
    mozilla::Maybe<bool> disabledialog;
    mozilla::Maybe<bool> firsttimetoggle;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (callout) {
        extraKeys.AppendElement()->AssignASCII("callout");
        extraValues.AppendElement()->AssignASCII(callout.value() ? "true" : "false");
      }
      if (disabledialog) {
        extraKeys.AppendElement()->AssignASCII("disableDialog");
        extraValues.AppendElement()->AssignASCII(disabledialog.value() ? "true" : "false");
      }
      if (firsttimetoggle) {
        extraKeys.AppendElement()->AssignASCII("firstTimeToggle");
        extraValues.AppendElement()->AssignASCII(firsttimetoggle.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records the method for opening the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.opened_method#toggle.
   */
  constexpr impl::EventMetric<OpenedMethodToggleExtra> opened_method_toggle(5204);

  /**
   * generated from pictureinpicture.opened_method_url_bar
   */
  struct OpenedMethodUrlBarExtra {
    mozilla::Maybe<bool> callout;
    mozilla::Maybe<bool> disabledialog;
    mozilla::Maybe<bool> firsttimetoggle;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (callout) {
        extraKeys.AppendElement()->AssignASCII("callout");
        extraValues.AppendElement()->AssignASCII(callout.value() ? "true" : "false");
      }
      if (disabledialog) {
        extraKeys.AppendElement()->AssignASCII("disableDialog");
        extraValues.AppendElement()->AssignASCII(disabledialog.value() ? "true" : "false");
      }
      if (firsttimetoggle) {
        extraKeys.AppendElement()->AssignASCII("firstTimeToggle");
        extraValues.AppendElement()->AssignASCII(firsttimetoggle.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records the method for opening the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.opened_method#urlBar.
   */
  constexpr impl::EventMetric<OpenedMethodUrlBarExtra> opened_method_url_bar(5205);

  /**
   * generated from pictureinpicture.resize_player
   */
  struct ResizePlayerExtra {
    mozilla::Maybe<uint32_t> height;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<uint32_t> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (height) {
        extraKeys.AppendElement()->AssignASCII("height");
        extraValues.AppendElement()->AppendInt(height.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.AppendElement()->AppendInt(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the Picture-in-Picture player window is resized. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.resize#player.
   */
  constexpr impl::EventMetric<ResizePlayerExtra> resize_player(5206);

  /**
   * generated from pictureinpicture.saw_toggle_toggle
   */
  struct SawToggleToggleExtra {
    mozilla::Maybe<bool> firsttime;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (firsttime) {
        extraKeys.AppendElement()->AssignASCII("firstTime");
        extraValues.AppendElement()->AssignASCII(firsttime.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the Picture-in-Picture toggle is shown This event was generated to correspond to the Legacy Telemetry event pictureinpicture.saw_toggle#toggle.
   */
  constexpr impl::EventMetric<SawToggleToggleExtra> saw_toggle_toggle(5207);

  /**
   * generated from pictureinpicture.subtitles_shown_subtitles
   */
  struct SubtitlesShownSubtitlesExtra {
    mozilla::Maybe<bool> webvttsubtitles;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (webvttsubtitles) {
        extraKeys.AppendElement()->AssignASCII("webVTTSubtitles");
        extraValues.AppendElement()->AssignASCII(webvttsubtitles.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records if subtitles are shown in the Picture-in-Picture window. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.subtitles_shown#subtitles.
   */
  constexpr impl::EventMetric<SubtitlesShownSubtitlesExtra> subtitles_shown_subtitles(5208);

  /**
   * generated from pictureinpicture.toggle_enabled
   * Whether the user has Picture-in-Picture enabled. This metric was generated to correspond to the Legacy Telemetry scalar pictureinpicture.toggle_enabled.
   */
  constexpr impl::BooleanMetric toggle_enabled(5209);

  /**
   * generated from pictureinpicture.window_open_duration
   * The length of time (in seconds) that a Picture-in-Picture window was open.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_PICTURE_IN_PICTURE_WINDOW_OPEN_DURATION.
   */
  constexpr impl::TimingDistributionMetric window_open_duration(5210);
}

namespace pictureinpicture_settings {
  /**
   * generated from pictureinpicture.settings.disable_player
   */
  /**
   * Recorded with "settings" object when Picture-in-Picture is disabled via settings Recorded with "player" object when Picture-in-Picture is disabled via PiP context menu This event was generated to correspond to the Legacy Telemetry event pictureinpicture.settings.disable#player.
   */
  constexpr impl::EventMetric<NoExtraKeys> disable_player(5211);

  /**
   * generated from pictureinpicture.settings.disable_settings
   */
  /**
   * Recorded with "settings" object when Picture-in-Picture is disabled via settings Recorded with "player" object when Picture-in-Picture is disabled via PiP context menu This event was generated to correspond to the Legacy Telemetry event pictureinpicture.settings.disable#settings.
   */
  constexpr impl::EventMetric<NoExtraKeys> disable_settings(5212);

  /**
   * generated from pictureinpicture.settings.enable_autotrigger_settings
   */
  /**
   * Recorded when the Picture-in-Picture auto-trigger is enabled. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.settings.enable_autotrigger#settings.
   */
  constexpr impl::EventMetric<NoExtraKeys> enable_autotrigger_settings(5213);

  /**
   * generated from pictureinpicture.settings.enable_settings
   */
  /**
   * Recorded when Picture-in-Picture is enabled. This event was generated to correspond to the Legacy Telemetry event pictureinpicture.settings.enable#settings.
   */
  constexpr impl::EventMetric<NoExtraKeys> enable_settings(5214);
}

} // namespace mozilla::glean

#endif // mozilla_GleanPictureinpictureMetrics_h
