// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanWidgetWindowsMetrics_h
#define mozilla_GleanWidgetWindowsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace widget {
  /**
   * generated from widget.ime_name_on_windows
   * Locale ID and name of IME which was selected by users on Windows. This does NOT collect legacy IMM-IME names since we cannot get readable names and we do not support IMM-IME so aggressively because IME vendors should've already released TIP for TSF for supporting Windows 8 or later completely. This metric was generated to correspond to the Legacy Telemetry scalar widget.ime_name_on_windows.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> ime_name_on_windows(6042);

  /**
   * generated from widget.ime_name_on_windows_inserted_crlf
   * Same data as ime_name_on_windows, but only collecting IME names which inserted CRLF to check whether the feature works. This metric was generated to correspond to the Legacy Telemetry scalar widget.ime_name_on_windows_inserted_crlf.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> ime_name_on_windows_inserted_crlf(6043);

  /**
   * generated from widget.touch_enabled_device
   */
  enum class TouchEnabledDeviceLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Boolean indicating if a touch input device is detected.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram TOUCH_ENABLED_DEVICE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, TouchEnabledDeviceLabel> touch_enabled_device(6044);
}

namespace windows_security {
  /**
   * generated from windows.security.antispyware
   * Product names of registered antispyware programs.
   * Windows only.
   */
  constexpr impl::StringListMetric antispyware(6053);

  /**
   * generated from windows.security.antivirus
   * Product names of registered antivirus programs.
   * Windows only.
   */
  constexpr impl::StringListMetric antivirus(6054);

  /**
   * generated from windows.security.firewall
   * Product names of registered firewall programs.
   * Windows only.
   */
  constexpr impl::StringListMetric firewall(6055);
}

} // namespace mozilla::glean

#endif // mozilla_GleanWidgetWindowsMetrics_h
