/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* Generated with cbindgen:0.29.1 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>

namespace mozilla {
namespace intl {
namespace ffi {

struct LangTag;

extern "C" {

/// Parse a string as a BCP47 language tag. Returns a `LangTag` object if the string is
/// successfully parsed; this must be freed with `lang_tag_destroy`.
///
/// The string `tag` must outlive the `LangTag`.
///
/// Returns null if `tag` is not a well-formed BCP47 tag (including if it is not
/// valid UTF-8).
LangTag *lang_tag_new(const nsACString *tag);

/// Free a `LangTag` instance.
void lang_tag_destroy(LangTag *lang);

/// Matches an HTML language attribute against a CSS :lang() selector using the
/// "extended filtering" algorithm.
/// The attribute is a BCP47 language tag that was successfully parsed by oxilangtag;
/// the selector is a string that is treated as a language range per RFC 4647.
bool lang_tag_matches(const LangTag *attribute, const nsACString *selector);

}  // extern "C"

}  // namespace ffi
}  // namespace intl
}  // namespace mozilla
